//
//  GMConsultantInfoModel.h
//  Gengmei
//
//  Created by zhouLiang on 2020/3/9.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//
@import GMBase;

@protocol GMHospitalInfoModel @end
@interface GMHospitalInfoModel : GMObject
/** 医院名称 */
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *portrait;
@property (nonatomic, assign) NSInteger level;
@property (nonatomic, copy) NSString *id;
@property (nonatomic, copy) NSString *type;
@property (nonatomic, copy) NSString *url;
@end

@interface GMConsultantInfoModel : GMObject

@property (nonatomic, copy) NSString *counsellorId;
/** 状态, 1:离线,2:在线,3:面诊中 */
@property (nonatomic, assign) NSInteger status;
/** 面诊师对应的用户ID */
@property (nonatomic, assign) NSInteger userId;
/** 面诊师头像 */
@property (nonatomic, copy) NSString *portrait;
/** 医院id */
@property (nonatomic, copy) NSString *hospitalId;
/** 性别, 1: 男, 2:女 */
@property (nonatomic, assign) NSInteger gender;
/** 是否已关注 */
@property (nonatomic, assign) BOOL isFollow;
/** 用户昵称 */
@property (nonatomic, copy) NSString *nickname;
/** 目前固定为面诊师 */
@property (nonatomic, copy) NSString *title;
/** 地区 */
@property (nonatomic, copy) NSString *area;
/** 从业时长，单位年 */
@property (nonatomic, assign) NSInteger employmentDuration;
/** 面诊数 */
@property (nonatomic, copy) NSString *historyConsultationCount;
/** 累计在线时长 */
@property (nonatomic, copy) NSString *historyConsultationOnline;
/** 粉丝数 */
@property (nonatomic, copy) NSString *fanNum;
/** 擅长项目 */
@property (nonatomic, strong) NSArray *goodAt;
/** 面诊师简介 */
@property (nonatomic, copy) NSString *introduction;
/** 医院名字 */
@property (nonatomic, strong) GMHospitalInfoModel *hospitalInfo;
/** 私信协议咨询 */
@property (nonatomic, copy) NSString *messageUrl;

/** 好评率 */
@property (nonatomic, copy) NSString *likeRate;
/** 接通率 */
@property (nonatomic, copy) NSString *connectRate;
/** 有效面诊人数 */
@property (nonatomic, copy) NSString *consultPeopleNumber;

@end
