//
//  GMToFaceDoctorBlockInfoView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/2/23.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceDoctorBlockInfoView.h"
#import "GMLibraryHeader.h"
//#import "UIView+GMGradient.h"

@interface GMToFaceDoctorBlockInfoView ()
@property (nonatomic, strong) GMLabel *titleLabel;
@end

@implementation GMToFaceDoctorBlockInfoView

- (instancetype)init {
    if (self = [super init]) {
        [self setUI];
    }
    return self;
}
- (void)setUI {
    [self addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.top.mas_equalTo(10);
        make.bottom.mas_equalTo(-10);
        make.height.mas_equalTo(46);
    }];
    //渐变色
    [self setGradientBackgroundWithColors:@[RGBCOLOR_HEX(0xFF7096),RGBCOLOR_HEX(0xFF5963)] locations:nil startPoint:CGPointMake(0, 0) endPoint:CGPointMake(1, 0)];
    self.alpha = 0.7;
}

- (void)setBlockInfo:(NSString *)blockInfo {
    self.titleLabel.text = SafeString(blockInfo);
    self.hidden = ![SafeString(blockInfo) isNonEmpty];
    CGSize size = [self.titleLabel sizeThatFits:CGSizeMake(MAINSCREEN_WIDTH - 40, 100)];
    [self.titleLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(size.height);
    }];
}
- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:11];
        _titleLabel.font = [UIFont gmBoldFont:11];
        _titleLabel.numberOfLines = 0;
    }
    return _titleLabel;
}
@end
