//
//  GMToFaceDoctorListHeaderFlowLayout.m
//  Gengmei
//
//  Created by Jessica on 2020/3/28.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceDoctorListHeaderFlowLayout.h"
#define ActiveDistance itemWidth
#define itemScale 0.88
#define itemWidth ((MAINSCREEN_WIDTH - 12 - itemLineSpacing) / 1.7)
#define itemSmallWidth (itemWidth * itemScale)
#define itemLineSpacing 0
#define itemInteritemSpacing 12
@interface GMToFaceDoctorListHeaderFlowLayout()
// 存储布局信息
@property(nonatomic, strong) NSArray *layoutInfoArr;

@end
@implementation GMToFaceDoctorListHeaderFlowLayout
- (instancetype)init {
    if ([super init] == self) {
        self.scrollDirection = UICollectionViewScrollDirectionHorizontal;
          self.itemSize = CGSizeMake(itemWidth, itemWidth);
          self.sectionInset = UIEdgeInsetsMake(15, 12, 15, 0);
        // 因为有放大缩小 所以间距设置为0
          self.minimumLineSpacing = itemLineSpacing;
          self.minimumInteritemSpacing = itemInteritemSpacing;
        self.contentOffsetX = (12 + itemWidth / 2.0) / MAINSCREEN_WIDTH;
    }
    return self;
}

- (NSArray<UICollectionViewLayoutAttributes *> *)layoutAttributesForElementsInRect:(CGRect)rect {
    return [self cardScaleTypeInRect:rect];
}

//卡片缩放
- (NSArray<UICollectionViewLayoutAttributes *> *)cardScaleTypeInRect:(CGRect)rect{
    NSArray *array = [self getCopyOfAttributes:[super layoutAttributesForElementsInRect:rect]];
    CGRect  visibleRect = CGRectZero;
    visibleRect.origin = self.collectionView.contentOffset;
    visibleRect.size = self.collectionView.bounds.size;
    for (int i = 0; i < array.count; i++) {
        UICollectionViewLayoutAttributes *attributes = array[i];
        // 计算中心点距离
        CGFloat delta = fabs(visibleRect.origin.x + 12 + itemWidth / 2.0 - attributes.center.x);
        // q计算比例
        CGFloat scale = 1 - delta / ActiveDistance * 0.12;
        attributes.transform = CGAffineTransformMakeScale(scale, scale);
    }
    return array;
}

- (NSArray *)getCopyOfAttributes:(NSArray *)attributes
{
    NSMutableArray *copyArr = [NSMutableArray new];
    for (UICollectionViewLayoutAttributes *attribute in attributes) {
        [copyArr addObject:[attribute copy]];
    }
    return copyArr;
}

- (BOOL)shouldInvalidateLayoutForBoundsChange:(CGRect)newBounds {
    return ![self.collectionView isPagingEnabled];
}

/**
 * collectionView停止滚动时的偏移量
 */
- (CGPoint)targetContentOffsetForProposedContentOffset:(CGPoint)proposedContentOffset withScrollingVelocity:(CGPoint)velocity
{
    CGRect rect;
    rect.origin.y = 0;
    rect.origin.x = proposedContentOffset.x;
    rect.size = self.collectionView.frame.size;
    NSArray *array = [super layoutAttributesForElementsInRect:rect];


    CGFloat centerX = proposedContentOffset.x + self.collectionView.frame.size.width * self.contentOffsetX;
    CGFloat minDelta = MAXFLOAT;
    for (UICollectionViewLayoutAttributes *attrs in array) {
        if (ABS(minDelta) > ABS(attrs.center.x - centerX)) {
            minDelta = attrs.center.x - centerX;
        }
    }

    proposedContentOffset.x += minDelta;
    self.currentIndex = round((ABS(proposedContentOffset.x))/(self.itemSize.width + self.minimumLineSpacing));

    return proposedContentOffset;

}
@end
