//
//  GMNimChannelManager.h
//  Gengmei
//
//  Created by Jessica on 2020/4/16.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <NIMSDK/NIMSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^NIMResultBlock)(BOOL isSuccess);
typedef void(^NIMResultCreateBlock)(NIMSignalingChannelInfo *);

@interface GMNimChannelManager : NSObject
/// 初始化
+ (instancetype)shareInstance;


/// 创建频道
/// @param channelName 频道名称
/// @param channelType 类型
/// @param resultBlock 结果
- (void)doCreateChannelWithChannelName:(NSString *)channelName channelType:(NIMSignalingChannelType)channelType resultBlock:(nonnull NIMResultCreateBlock)resultBlock;

/// 加入频道
/// @param channelId channelId
/// @param resultBlock 结果
- (void)doJoinChannelWithChannelId:(NSString *)channelId resultBlock:(NIMResultBlock)resultBlock;

/// 离开频道
/// @param channelId channelId
/// @param resultBlock 结果
- (void)doLeaveChannelWithChannelId:(NSString *)channelId resultBlock:(NIMResultBlock)resultBlock;

/// 关闭频道
/// @param channelId channelId
/// @param resultBlock 结果
- (void)doCloseChannelWithChannelId:(NSString *)channelId resultBlock:(NIMResultBlock)resultBlock;

///  邀请加入频道
/// @param channelId 频道Id 必填
/// @param accountId 对方，被邀请人，必填
/// @param customInfo 通知事件额外字段，非必填（邀请者附加的自定义信息，透传给被邀请者）
/// @param resultBlock 结果
- (void)doInviteJoinWithChannelId:(NSString *)channelId accountId:(NSString *)accountId customInfo:(NSString *)customInfo resultBlock:(nonnull NIMResultBlock)resultBlock;

///  取消邀请
/// @param channelId 频道Id 必填
/// @param accountId 对方，被邀请人，必填
/// @param customInfo 通知事件额外字段，非必填（邀请者附加的自定义信息，透传给被邀请者）
/// @param resultBlock 结果
- (void)doCancelInviteWithChannelId:(NSString *)channelId accountId:(NSString *)accountId customInfo:(NSString *)customInfo resultBlock:(nonnull NIMResultBlock)resultBlock;

///  接受邀请
/// @param channelId 频道Id 必填
/// @param accountId 对方，被邀请人，必填
/// @param acceptCustomInfo 通知事件额外字段，非必填(被邀请者附加的自定义信息，透传给邀请者)
/// @param resultBlock 结果
- (void)doAcceptInviteWithChannelId:(NSString *)channelId accountId:(NSString *)accountId acceptCustomInfo:(NSString *)acceptCustomInfo resultBlock:(nonnull NIMResultBlock)resultBlock;

///  拒绝邀请
/// @param channelId 频道Id 必填
/// @param accountId 对方，被邀请人，必填
/// @param customInfo 通知事件额外字段，非必填
/// @param resultBlock 结果
- (void)doRejectInviteWithChannelId:(NSString *)channelId accountId:(NSString *)accountId customInfo:(NSString *)customInfo resultBlock:(nonnull NIMResultBlock)resultBlock;

/// 直接呼叫
/// @param accountId 对方accid，被邀请者的账号
/// @param customInfo 通知事件额外字段，非必填
/// @param resultBlock 结果
- (void)doCallWithAccountId:(NSString *)accountId customInfo:(NSString *)customInfo resultBlock:(nonnull NIMResultBlock)resultBlock;
@end

NS_ASSUME_NONNULL_END
