//
//  GMRtcManager.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TTTRtcEngineKit/TTTRtcEngineKit.h>
#import "GMTTTUser.h"
#import "GMVideoTelephoneModel.h"
#import "GMVideoTelephoneRequestTool.h"

typedef NS_ENUM(NSUInteger, TelephoneVideoStatus) {
    TelephoneVideoStatus_rest,// 闲置中
    TelephoneVideoStatus_wating, //等待中
    TelephoneVideoStatus_video,//视频中
};
typedef struct {
    BOOL isCustom;
    CGSize videoSize;
    NSUInteger videoBitRate;
    NSUInteger fps;
}TTTCustomVideoProfile;

static CGSize TTTVideoMixSize[] = {
    [TTTRtc_VideoProfile_120P] = {160, 120},
    [TTTRtc_VideoProfile_180P] = {320, 180},
    [TTTRtc_VideoProfile_240P] = {320, 240},
    [TTTRtc_VideoProfile_360P] = {640, 360},
    [TTTRtc_VideoProfile_480P] = {640, 480},
    [TTTRtc_VideoProfile_720P] = {1280, 720},
    [TTTRtc_VideoProfile_1080P] = {1920, 1080},
};

static NSString *videoSizeStr[] = {
    [TTTRtc_VideoProfile_120P]  = @"160x120",
    [TTTRtc_VideoProfile_180P]  = @"320x180",
    [TTTRtc_VideoProfile_240P]  = @"320x240",
    [TTTRtc_VideoProfile_360P]  = @"640x360",
    [TTTRtc_VideoProfile_480P]  = @"848x480",
    [TTTRtc_VideoProfile_720P]  = @"1280x720",
    [TTTRtc_VideoProfile_1080P] = @"1920x1080",
};

static NSString *videoBitrateStr[] = {
    [TTTRtc_VideoProfile_120P]  = @"65",
    [TTTRtc_VideoProfile_180P]  = @"140",
    [TTTRtc_VideoProfile_240P]  = @"200",
    [TTTRtc_VideoProfile_360P]  = @"400",
    [TTTRtc_VideoProfile_480P]  = @"500",
    [TTTRtc_VideoProfile_720P]  = @"1130",
    [TTTRtc_VideoProfile_1080P] = @"2080",
};

@interface GMRtcManager : NSObject
@property (nonatomic, strong) TTTRtcEngineKit *rtcEngine;

/// 用户数组
@property (nonatomic, assign) NSMutableArray<GMTTTUser *> *userArray;

/// 面诊发起/接收返回的数据
@property (nonatomic, strong) GMVideoTelephoneModel *vidoeTelephoneModel;

/// 自己(三体sdk中的对象)
@property (nonatomic, strong) GMTTTUser *me;

/// 房间id
@property (nonatomic, assign) int64_t roomID;

/// 通话时长 （s）
@property (nonatomic, assign) int totalTime;
/// 面诊记录ID
@property (nonatomic, strong) NSString *consultationRecordId;
//settings 是否自定义
@property (nonatomic, assign) BOOL isCustom;
//-local
@property (nonatomic, assign) BOOL isHighQualityAudio;
@property (nonatomic, assign) TTTRtcVideoProfile localProfile;//set default is 360P
@property (nonatomic, assign) TTTCustomVideoProfile localCustomProfile;
//cdn
@property (nonatomic, assign) BOOL h265;
@property (nonatomic, assign) BOOL doubleChannel;
@property (nonatomic, assign) TTTRtcVideoProfile cdnProfile;
@property (nonatomic, assign) TTTCustomVideoProfile cdnCustom;

@property (nonatomic, strong) TTTRtcVideoCompositingLayout *videoLayout;

/// 推流地址
@property (nonatomic, strong) NSString *pushURL;
/// 电话状态
@property (nonatomic, assign) TelephoneVideoStatus telephoneStatus;
/// 初始化方法（单利）
+ (instancetype)sharedRtcManager;

/// 注销直播间
- (void)closeExcitRoom;

///静音api
/// @param status 是否静音
- (void)muteLocalAudioStream:(BOOL) status;

/// 切换摄像头
- (void)switchCamera;


/// 是否打开美颜
/// @param status yes 开 no关
- (void)beautyStatus:(BOOL)status;

/// 设置合成视频位置信息
/// @param windowStatus 标记窗口状态 no 用户小窗 yes 是医生小窗
/// @param userId 用户id
/// @param doctorId 医生id
- (void)setTelephoneVideoCompositingLayout:(BOOL)windowStatus userId:(int64_t)userId doctorId:(int64_t)doctorId ;
@end

