//
//  GMTelephoneAudioPlay.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/23.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTelephoneAudioPlay.h"
#import <AVFoundation/AVFoundation.h>

@interface GMTelephoneAudioPlay ()
@property (nonatomic, strong) AVAudioPlayer *audioPlay;
@end

@implementation GMTelephoneAudioPlay
- (GMTelephoneAudioPlay *)initWithAudioSource:(NSString *)name ofType:(nonnull NSString *)type{
    self = [super init];
    if (self) {
        NSString *soundPath = [[NSBundle mainBundle] pathForResource:name ofType:type];
                 NSURL *soundUrl = [NSURL fileURLWithPath:soundPath];
         //初始化播放器对象
         self.audioPlay = [[AVAudioPlayer alloc]initWithContentsOfURL:soundUrl error:nil];
         //设置声音的大小
         self.audioPlay.volume = 0.5;//范围为（0到1）；
         //设置循环次数，如果为负数，就是无限循环
         self.audioPlay.numberOfLoops =-1;
         //设置播放进度
         self.audioPlay.currentTime = 0;
         //准备播放
         [self.audioPlay prepareToPlay];
    }
    return self;
}


- (void) startAudioPlay {
    self.audioPlay.currentTime = 0;
    [self.audioPlay prepareToPlay];
    [self.audioPlay play];
}

- (void) stopAudioPlay {
    [self.audioPlay pause];
}
@end
