//
//  GMVideoTelephoneRequestTool.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMVideoTelephoneModel.h"
#import "GMTelphoneStatusModel.h"
#import "GMTelephoneRecommodWelfareModel.h"

typedef NS_ENUM(NSUInteger, GMEventType) {
    GMEventType_add = 1,//1.被邀请加入(服务端通知医生端）
    GMEventType_addSuccess = 2,//2.加入成功(SDK加入房间成功之后上报, 用户端/医生端都需要)
    GMEventType_addFail = 3, //3. 加入失败(SDK加入房间失败之后上报, 用户端/医生端都需要)
    GMEventType_jieTing = 4,//4. 接听(医生点击接听按钮之后上报)
    GMEventType_juJue = 5,//5.拒绝(医生点击拒绝接听之后上报)
    GMEventType_zhuDongExit= 6,//6.主动退出(通话过程中，一方挂断时候上报，该情况下 客户端需要关注响应）
    GMEventType_beiDongExit = 7,//7.被动退出 (通话过程中，一方收到SDK回调另一方频道时候，上报，该情况下客户端需要关注响应）
    GMEventType_video = 8,//8.心跳事件（通话中，周期上报，用户端/医生端都需要上报)
    GMEventType_shoppingRecommend = 9,//9.推荐袋数据有更新（当医生端更新推荐袋的时候，推送给用户端）

};

@interface GMVideoTelephoneRequestTool : NSObject

/// 关注接口
+ (void)followOrNot:(BOOL)status withUid:(NSString *)uid type:(NSString *)type finishBlock:(void (^)(BOOL success, NSString *message))finishBlock;

/// 用户呼出接口
+ (void)userVideoTelephoneMessage:(NSDictionary *)params finishBlock:(void (^)(BOOL success, NSDictionary *modelDict, NSString *errorMessage))finishBlock;


/// 医生呼入接口
+ (void)doctorVideoTelephoneMessage:(NSDictionary *)params finishBlock:(void (^)(BOOL success, NSDictionary *modelDict, NSString *errorMessage))finishBlock ;


/// 视频通话流程事件上报
/// @param eventType 事件类型:
/// 1.被邀请加入(服务端通知医生端）
///2.加入成功(SDK加入房间成功之后上报, 用户端/医生端都需要)
///3. 加入失败(SDK加入房间失败之后上报, 用户端/医生端都需要)
///4. 接听(医生点击接听按钮之后上报)
///5.拒绝(医生点击拒绝接听之后上报)
///6.主动退出(通话过程中，一方挂断时候上报，该情况下 客户端需要关注响应）
///7.被动退出 (通话过程中，一方收到SDK回调另一方频道时候，上报，该情况下客户端需要关注响应）
///8.心跳事件（通话中，周期上报，用户端/医生端都需要上报)
///9.推荐袋数据有更新（当医生端更新推荐袋的时候，推送给用户端）
/// @param consultationRecordId 面诊记录ID
/// @param finishBlock 回调
+ (void)telephoneMessageEventType:(GMEventType)eventType
consultationRecordId:(NSString *)consultationRecordId
         finishBlock:(void (^)(BOOL success, NSDictionary *message))finishBlock;

/// 用户端推荐美购列表
/// @param params 参数
/// @param finishBlock 回调
+ (void)userVideoTelephoneRecommodWelfare:(NSDictionary *)params finished:(void (^)(BOOL success, NSMutableArray *dataArray))finishBlock;
@end

