//
//  GMAISearchNavigationView.m
//  Gengmei
//
//  Created by ioszhb on 2019/2/1.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "GMAISearchNavigationView.h"
@interface GMAISearchNavigationView ()<UITextFieldDelegate>
@property (nonatomic, strong) GMButton *cancelButton;
/// textFiledCover
@property (nonatomic, strong) GMView *textCoverView;
@end

@implementation GMAISearchNavigationView

- (void)setup {
    [super setup];
    [self setupSubviews];
    [self setupConstraints];
}

- (void)setupSubviews {
    [self addSubview:self.textField];
    [self addSubview:self.cancelButton];
    [self.textField addSubview:self.textCoverView];
}

- (void)setupConstraints {
    [self.textField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(6);
        make.bottom.mas_equalTo(-6);
        make.left.mas_equalTo(20);
    }];
    
    [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.textField.mas_right).offset(20);
        make.right.mas_equalTo(-20);
        make.top.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
        make.width.mas_equalTo(32);
    }];
    
    [self.textCoverView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(0);
    }];
}

- (void)updateSuberConstraints {
    [self.cancelButton mas_updateConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(_showCancelButton ? -20 : 0);
        make.width.mas_equalTo(_showCancelButton ? 32 : 0);
    }];
}

#pragma mark - Setter

- (void)setShowCancelButton:(BOOL)showCancelButton{
    [self setShowCancelButton:showCancelButton animated:YES];
}

- (void)setShowCancelButton:(BOOL)showCancelButton animated:(BOOL)animated{
    _showCancelButton = showCancelButton;
    [self updateSuberConstraints];
    if (animated) {
        [UIView animateWithDuration:0.2 animations:^{
            [self layoutIfNeeded];
        }];
    }
}


#pragma mark - Action
- (void)cancelAction {
    if ([self.delegate respondsToSelector:@selector(searchNavigationCancelButtonClick)]) {
        [self.delegate searchNavigationCancelButtonClick];
    }
}

/// 手动点击开始文本编辑
- (void)beiginTextEdit {
    [Phobos track:@"on_click_navbar_search" attributes:@{@"page_name":self.pageName}];
    [self.textField becomeFirstResponder];
}

#pragma mark - 重写
- (BOOL)resignFirstResponder{
    self.showCancelButton = NO;
    [_textField resignFirstResponder];
    return [super resignFirstResponder];
}

- (BOOL)becomeFirstResponder{
    self.showCancelButton = YES;
    [_textField becomeFirstResponder];
    return [super becomeFirstResponder];
}

#pragma mark - getter subviews
- (UITextField *)textField {
    if (!_textField) {
        _textField = [UITextField new];
        _textField.delegate = self;
        _textField.backgroundColor = UIColor.background;
        _textField.enablesReturnKeyAutomatically = NO;
        _textField.returnKeyType = UIReturnKeySearch;
        _textField.clearButtonMode = UITextFieldViewModeWhileEditing;
        _textField.layer.cornerRadius = 16;
        _textField.layer.masksToBounds = YES;
        _textField.attributedPlaceholder = [[NSAttributedString alloc] initWithString:@"搜索项目、美购、医生" attributes:@{
            NSFontAttributeName:[UIFont systemFontOfSize:14],
            NSForegroundColorAttributeName:UIColor.auxiliaryTextLight
        }];
        _textField.hasCloseButton = YES;
        UIImage *imge = [UIImage imageNamed:@"home_new_search"];
        UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 30, 30)];
        UIImageView *leftView = [[UIImageView alloc] initWithImage:imge];
        leftView.image = imge;
        leftView.frame = CGRectMake(0, 0, imge.size.width, imge.size.height);
        leftView.center = view.center;
        [view addSubview:leftView];
        
        _textField.leftView = view;
        _textField.leftViewMode = UITextFieldViewModeAlways;
        _textField.font = [UIFont gmFont:14];
        _textField.textColor = [UIColor blackColor];
    }
    return _textField;
}

- (GMButton *)cancelButton {
    if (!_cancelButton) {
        _cancelButton = [GMButton new];
        _cancelButton.backgroundColor = [UIColor whiteColor];
        [_cancelButton addTarget:self action:@selector(cancelAction) forControlEvents:UIControlEventTouchUpInside];
        [_cancelButton setTitle:@"取消" forState:UIControlStateNormal];
        [_cancelButton setTitleColor:UIColor.headlineText forState:UIControlStateNormal];
        _cancelButton.titleLabel.font = [UIFont gmFont:15];
    }
    
    return _cancelButton;
}

- (GMView *)textCoverView {
    if (!_textCoverView) {
        _textCoverView = [GMView new];
        _textCoverView.userInteractionEnabled = YES;
        _textCoverView.backgroundColor = [UIColor clearColor];
        UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(beiginTextEdit)];
        [_textCoverView addGestureRecognizer:tapGesture];
    }
    return _textCoverView;
}

@end

