//
//  GMAVRegionView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMAVRegionView.h"
#import "GMRtcManager.h"

@interface GMAVRegionView()


@end

@implementation GMAVRegionView
{
    UIView *_backgroundView;
    GMRtcManager *TTManager;
}
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        TTManager = [GMRtcManager sharedRtcManager];
        [self setupUI];
    }
    return self;
}

- (void)layoutSubviews {
    _backgroundView.frame = self.bounds;
    _videoView.frame = self.bounds;
}
- (void)setupUI {
    _backgroundView = [[UIView alloc] initWithFrame:self.bounds];
    [self addSubview:_backgroundView];
    _videoView = [[UIImageView alloc] initWithFrame:self.bounds];
    _videoView.layer.masksToBounds = YES;
    [_videoView setContentMode:UIViewContentModeScaleAspectFill];
    [self addSubview:_videoView];
}

- (int)configureRegion:(GMTTTUser *)user {
    self.hidden = NO;
    self.user = user;

    TTTRtcVideoCanvas *videoCanvas = [[TTTRtcVideoCanvas alloc] init];
    videoCanvas.uid = user.uid;
    videoCanvas.renderMode = TTTRtc_Render_Adaptive;
    videoCanvas.view = _videoView;
    int finishedTeye;
    if (TTManager.me == user) {
       finishedTeye = [TTManager.rtcEngine setupLocalVideo:videoCanvas];
    } else {
        finishedTeye = [TTManager.rtcEngine setupRemoteVideo:videoCanvas];
    }
    return finishedTeye;
}

/// 关闭t视频图层的方法
- (void)closeRegion {
    
}

@end
