//
//  GMDoctorTelephoneFunctionView.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, DoctorTelephoneFunctionType) {
    DoctorTelephoneFunctionType_shopping = 100,
    DoctorTelephoneFunctionType_song = 101,
    DoctorTelephoneFunctionType_guaDuan = 102,
    DoctorTelephoneFunctionType_meiyan = 103,
    DoctorTelephoneFunctionType_switchCamera = 104,
};


@protocol GMDoctorTelephoneFunctionViewDelegate <NSObject>

- (void)doctorClicBtnAction:(DoctorTelephoneFunctionType)type Status:(BOOL)status;

/// 记录通话时长
/// @param currentTime 时长
- (void)doctorTimeChange:(int)currentTime;

@end

@interface GMDoctorTelephoneFunctionView : UIView
@property (nonatomic, weak) id<GMDoctorTelephoneFunctionViewDelegate>delegate;

/// 时长
@property (nonatomic, assign) CGFloat currentTime;


/// 改变静音按钮装填
/// @param status bool
- (void)changMutedSelf:(BOOL) status;

/// 开始计时
- (void)startTime;

/// 结束计时
- (void)endTime;
@end

