//
//  GMLinkPromptView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/3/7.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMLinkPromptView.h"

@implementation GMLinkPromptView
{
    UILabel *_titleLabel;
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.font = [UIFont systemFontOfSize:14];
        _titleLabel.textColor = UIColor.whiteColor;
        _titleLabel.textAlignment = NSTextAlignmentCenter;
        [self addSubview:_titleLabel];
        self.layer.masksToBounds = YES;
        self.layer.cornerRadius = 10;
        self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.3];
    }
    return self;
}

- (void)setText:(NSString *)text {
    _text = text;
    _titleLabel.text = text;
    
    [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(UIEdgeInsetsMake(10, 30, 10, 30));
    }];
}


@end
