//
//  GMTelephoneShoppingEmptyView.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/21.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTelephoneShoppingEmptyView.h"
#import "GMLibraryHeader.h"

@implementation GMTelephoneShoppingEmptyView
{
    UIImageView *_icoImg;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = UIColor.whiteColor;
    _icoImg = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"telephone_shoppingEmpty"]];
    [self addSubview:_icoImg];
    
    _closeBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_closeBtn setBackgroundImage:[UIImage imageNamed:@"wt_cancel_icon"] forState:UIControlStateNormal];
    [_closeBtn setBackgroundImage:[UIImage imageNamed:@"wt_cancel_icon"] forState:UIControlStateHighlighted];
    [self addSubview:_closeBtn];
}

- (void)layoutSubviews {
    [_icoImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX);
        make.centerY.equalTo(self.mas_centerY);
    }];
    [_closeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(20, 20));
        make.top.equalTo(self.mas_top).offset(20);
        make.right.equalTo(self.mas_right).offset(-20);
    }];
}
@end
