//
//  GMVideoTelephoneWindow.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMAVRegionView.h"
#import "GMRtcManager.h"
#import "GMVideoTelephoneRequestTool.h"
@import CoreTelephony;

@protocol GMVideoTelephoneWindowDelegate <NSObject>


/// 关闭直播间
- (void)nomalExitRoom;

/// 直播中
- (void)videoLiveIn;


@end

@interface GMVideoTelephoneWindow : UIView

@property (nonatomic, weak) id<GMVideoTelephoneWindowDelegate>delgate;

@property (nonatomic, strong) GMAVRegionView *userVideoView;//用户的成像试图
@property (nonatomic, strong) GMAVRegionView *doctorVideoView;//医生的成像试图
@property (nonatomic, assign) BOOL windowStatu;//标记窗口状态 no 用户小窗 yes 是医生小窗
@property (nonatomic, strong) UIPanGestureRecognizer *pan;//拖拽收拾

@property (nonatomic, strong) NSString *pageName;

@property (nonatomic, strong) NSString *referer;

@property (nonatomic, strong) NSString *referrerTabName;

/// 电话监听
@property (nonatomic, strong) CTCallCenter * callCenter;
/// 拖拽开始
/// @param pan pan description
- (void)touchMove:(UIPanGestureRecognizer *)pan;

/// 拖拽结束
/// @param pan pan
- (void)touchEnd:(UIPanGestureRecognizer *)pan;

/// 重新设置约束条件
- (void)layoutVideoView;

/// 添加试图拖拽收拾
- (void)addVideoPan;

/// 切换医生用户大小试图
- (void)switchVideoWindow:(BOOL)status;

/// 计算宽度
/// @param message 字符串
/// @param font 字号
/// @param height 高度限制
- (CGFloat )getWidth:(NSString *)message font:(CGFloat)font LimitHeight:(CGFloat)height;

/// 对方超时没有接听
- (void)userExitTime;
@end

