//
//  GMVideoTelephoneWindow.m
//  Gengmei
//
//  Created by 卢悦明 on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoTelephoneWindow.h"
#import <GMBase/GMBaseTool.h>

@import GMHud;
@interface GMVideoTelephoneWindow ()

@end

@implementation GMVideoTelephoneWindow

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.layer.masksToBounds = YES;
        UIViewController *vc = [GMBaseTool getCurrentViewController].navigationController.viewControllers.lastObject;
        self.referer = vc.pageName;
        self.referrerTabName = vc.tabName;
        
        //电话超时 需要用户/医生取消挂断
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(userExitTime) name:@"gm_telephone_cancal" object:nil];
        //网络发生变化
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(netWorkingChanged:) name:@"gm_networkingChang" object:nil];

        
    }
    return self;
}

- (void)userExitTime {}

- (void)netWorkingChanged:(NSNotification *)notifi {
    NSDictionary *dict = notifi.userInfo;
    NSInteger new = [dict[@"newStatus"] integerValue]; // 1 是手机网络 2 是wifi
    if (new == 1) {
        [GMHudModule showWarning:@"当前为非WiFi环境，请注意流量消耗！"];
    }
}

- (void)touchEnd:(UIPanGestureRecognizer *)pan {
    UIView *view = pan.view;
    CGRect frame = view.frame;
    CGFloat width = frame.size.width;
    CGFloat height = frame.size.height;
    CGFloat x = frame.origin.x;
    CGFloat y = frame.origin.y;
    CGFloat space = (CGRectGetWidth(view.superview.frame) - width) * 0.5;
    if (x < space) {
        x = 0;
    } else {
        x = CGRectGetWidth(view.superview.frame) - width;
    }
    [UIView animateWithDuration:0.2 animations:^{
        view.frame = CGRectMake(x, y, width, height);
    }];
}

- (void)touchMove:(UIPanGestureRecognizer *)pan {
    //获取偏移量
    // 返回的是相对于最原始的手指的偏移量
    CGPoint transP = [pan translationInView:pan.view];
    // 移动图片控件
    pan.view.transform = CGAffineTransformTranslate(pan.view.transform, transP.x, transP.y);
    CGRect frame = pan.view.frame;
    CGFloat width = frame.size.width;
    CGFloat height = frame.size.height;
    CGFloat x = frame.origin.x;
    CGFloat y = frame.origin.y;
    if (x < 0) {
        x = 0;
    } else if (x > ( CGRectGetWidth(pan.view.superview.frame) - width)) {
        x = CGRectGetWidth(pan.view.superview.frame) - width;
    }
    if (y < 0) {
        y = 0;
    } else if (y > (CGRectGetHeight(pan.view.superview.frame) - height)) {
        y = CGRectGetHeight(pan.view.superview.frame) - height;
    }
    pan.view.frame = CGRectMake(x, y, width, height);
    // 复位,表示相对上一次
    [pan setTranslation:CGPointZero inView:pan.view];
}

- (void)layoutVideoView {
    if (self.windowStatu) {
        self.userVideoView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
        self.doctorVideoView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleLeftMargin | UIViewAutoresizingFlexibleRightMargin | UIViewAutoresizingFlexibleBottomMargin | UIViewAutoresizingFlexibleTopMargin;
    } else {
        self.doctorVideoView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
        self.userVideoView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleLeftMargin | UIViewAutoresizingFlexibleRightMargin | UIViewAutoresizingFlexibleBottomMargin | UIViewAutoresizingFlexibleTopMargin;
    }
    
}

#pragma mark - 添加试图拖拽手势
- (void)addVideoPan {
    if (self.windowStatu) {//医生小窗口
        [self.doctorVideoView addGestureRecognizer: self.pan];

    } else {//用户小窗口
        [self.userVideoView addGestureRecognizer: self.pan];
    }
}

- (void)switchVideoWindow:(BOOL)status {
    self.windowStatu = status;
    CGRect fram = self.userVideoView.frame;
    self.userVideoView.frame = self.doctorVideoView.frame;
    self.userVideoView.layer.masksToBounds = YES;
    self.doctorVideoView.layer.masksToBounds = YES;
    self.doctorVideoView.frame = fram;
    if (self.windowStatu) {//医生小窗
        self.userVideoView.layer.cornerRadius = 0;
        self.doctorVideoView.layer.cornerRadius = 4;
        [self insertSubview:self.userVideoView atIndex:0];
    } else {//用户小窗
        self.userVideoView.layer.cornerRadius = 4;
        self.doctorVideoView.layer.cornerRadius = 0;
        [self insertSubview:self.doctorVideoView atIndex:0];
    }
    [self addVideoPan];
    [self layoutVideoView];
}

- (CGFloat )getWidth:(NSString *)message font:(CGFloat)font LimitHeight:(CGFloat)height{
    CGFloat width = ceil([message boundingRectWithSize:CGSizeMake(MAINSCREEN_WIDTH  , height) options: NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName: [UIFont systemFontOfSize:font]} context:nil].size.width);
    return width;
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
@end

