//
//  GMComplaintObject.h
//  Gengmei
//
//  Created by zhouLiang on 2020/2/22.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//
@import GMBase;

// 从杜欣前端给传的数据 --- 投诉结果
@interface GMComplaintObject : GMObject

@property (nonatomic, assign) NSInteger recordId;
@property (nonatomic, assign) NSInteger status;
@property (nonatomic, copy) NSString *report_time;//投诉时间
@property (nonatomic, copy) NSString *deal_time;//处理时间
@property (nonatomic, copy) NSString *report_detail;//投诉问题
@property (nonatomic, copy) NSString *deal_detail;//处理结果
@property (nonatomic, copy) NSString *custom_url;//更美客服私信
@end

// 从张禄接口获取的数据 --- 投诉结果

@interface GMSubComplaintObject : GMObject
///投诉已选择的标签
@property (nonatomic, strong) NSArray *complaintList;
///投诉时间
@property (nonatomic, copy) NSString *time;
///投诉内容
@property (nonatomic, copy) NSString *content;
@end

@interface GMComplaintInterfaceObject : GMObject
///投诉信息
@property (nonatomic, strong) GMSubComplaintObject *complaint;
///投诉状态 0:审核中, 1:已通过 2:已驳回
@property (nonatomic, assign) NSInteger status;
///客服回复信息
@property (nonatomic, strong) GMSubComplaintObject *reply;
///更美客服私信
@property (nonatomic, copy) NSString *custom_url;
@end
