//
//  GMWorkTableObject.h
//  Gengmei
//
//  Created by Jessica on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnosisWorkingTableSwitch.h"
@import GMBase;


@protocol GMWorkTableNotifyObject @end
@interface GMWorkTableNotifyObject : GMObject
/** 公告图片地址 */
@property (nonatomic, copy) NSString *image;
/** 跳转地址 */
@property (nonatomic, copy) NSString *url;
/** 标题 */
@property (nonatomic, copy) NSString *title;

@end


@protocol GMWorkTableIconObject @end
@interface GMWorkTableIconObject : GMObject
/** 图片地址 */
@property (nonatomic, copy) NSString *icon;
/** 跳转地址 */
@property (nonatomic, copy) NSString *url;
/** 标题 */
@property (nonatomic, copy) NSString *text;
/** 个数 */
@property (nonatomic, copy) NSString *badge;
@end

@interface GMWorkTableObject : GMObject
// 公告图片相关数据
@property (nonatomic,strong) NSArray<GMWorkTableNotifyObject> *notifies;
// icon功能区
@property (nonatomic,strong) NSArray<GMWorkTableIconObject> *iconList;

// 服务分
@property (nonatomic, copy) NSString *stars;
// 在线时长
@property (nonatomic, copy) NSString *onlineTime;
// 服务人数
@property (nonatomic, copy) NSString *users;
// 待写面诊报告数
@property (nonatomic, copy) NSString *reportsToWrite;
// 错过用户数
@property (nonatomic, copy) NSString *miss;

// 数据明细
@property (nonatomic, copy) NSString *serverDataDetailUrl;

// 1.医生 2.面诊师
@property (nonatomic, assign) NSInteger counsellorType;

// 身份 （0医生 1助理）
@property (nonatomic, assign) NSInteger identity;
//  面诊状态（1代表可以开启面诊，2代表可以关闭面诊，3代表正在面诊中）
@property (nonatomic, assign) DiagnosisWorkingTableSwitchStatus status;
//  工作台面诊状态文字，和status相关
@property (nonatomic, copy) NSString *statusText;


/** 好评率 */
@property (nonatomic, copy) NSString *likeRate;
/** 接通率 */
@property (nonatomic, copy) NSString *connectRate;
/** 有效面诊人数 */
@property (nonatomic, copy) NSString *consultPeopleNumber;

@end
