//
//  GMDiagnosisDispatchInfoView.m
//  Gengmei
//
//  Created by Jessica on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnosisDispatchInfoView.h"
@import GMBase;

@implementation GMDiagnosisDispatchInfoView
- (void)setup {
    [super setup];
    _locationIcon = [[GMImageView alloc] init];
    _locationIcon.image = [UIImage imageNamed:@"wt_location_icon"];
    [self addSubview:_locationIcon];
    
    [_locationIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(12, 16));
        make.left.mas_equalTo(0);
        make.top.mas_equalTo(0);
    }];
    
    _locationLabel = [[UILabel alloc] init];
    _locationLabel.text = @"北京";
    _locationLabel.textColor = RGBCOLOR_HEX(0x282828);
    _locationLabel.font = [UIFont gmBoldFont:14];
    [self addSubview:_locationLabel];
    [_locationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_locationIcon.mas_centerY);
        make.left.mas_equalTo(_locationIcon.mas_right).offset(7);
        make.height.mas_equalTo(20);
    }];
    
    _infoLabel = [[UILabel alloc] init];
    _infoLabel.text = @"女，22岁，没做过医美";
    _infoLabel.textColor = RGBCOLOR_HEX(0x282828);
    _infoLabel.textAlignment = NSTextAlignmentCenter;
    _infoLabel.font = [UIFont gmBoldFont:14];
    [self addSubview:_infoLabel];
    [_infoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_locationIcon.mas_centerY);
        make.left.mas_equalTo(_locationLabel.mas_right).offset(16);
        make.height.mas_equalTo(20);
    }];
    
    _projectLabel = [[UILabel alloc] init];
    _projectLabel.text = @"咨询项目：皮肤美容 | 面部轮廓 | 眼部";
    _projectLabel.textColor = RGBCOLOR_HEX(0x282828);
    _projectLabel.font = [UIFont gmFont:13];
    [self addSubview:_projectLabel];
    [_projectLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_locationIcon.mas_bottom).offset(10);
        make.left.mas_equalTo(_locationIcon.mas_left);
        make.height.mas_equalTo(20);
        make.bottom.mas_equalTo(self.mas_bottom);
    }];
}

- (void)updateConstraints {
    [super updateConstraints];
    [_infoLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(_locationLabel.mas_right).offset(16);
    }];
    
    [_projectLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.mas_bottom);
    }];
}

@end
