//
//  GMDiagnosisWorkingTableHeaderView.m
//  Gengmei
//
//  Created by Jessica on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnosisWorkingTableHeaderView.h"
#import "GMWoikingTableCollectionCell.h"
#import "GMGMDiagnosisWorkingTableScrollView.h"
#import "RequestHeader.h"
#import "GMLibraryHeader.h"
//#import "WMBrowserViewController.h"
@import GMRouter;
@interface GMServiceDataItemView()
@property (nonatomic, strong) UILabel *line;
@end

@implementation GMServiceDataItemView
- (void)setup {
    [super setup];
    _dataLabel = [[UILabel alloc] init];
    _dataLabel.textColor = RGBCOLOR_HEX(0x282828);
    _dataLabel.textAlignment = NSTextAlignmentCenter;
    _dataLabel.font = [UIFont gmBoldFont:21];
    [self addSubview:_dataLabel];
    [_dataLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(16);
        make.height.mas_equalTo(30);
    }];
    
    _descLabel = [[UILabel alloc] init];
    _descLabel.textColor = RGBCOLOR_HEX(0x909399);
    _descLabel.textAlignment = NSTextAlignmentCenter;
    _descLabel.font = [UIFont gmFont:11];
    [self addSubview:_descLabel];
    [_descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(_dataLabel.mas_centerX);
        make.top.mas_equalTo(_dataLabel.mas_bottom);
        make.height.mas_equalTo(15);
    }];
    
    _line = [[UILabel alloc] init];
    _line.backgroundColor = RGBCOLOR_HEX(0xEEEEEE);
    [self addSubview:_line];
    [_line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(self.mas_centerY);
        make.right.mas_equalTo(self);
        make.width.mas_equalTo(ONE_PIXEL);
        make.height.mas_equalTo(15);
    }];

}

@end

@interface GMServiceDataView() {
    UILabel *_leftLine;
    UILabel *_rightLine;
    UILabel *_bottomLabel;
    NSArray *_descArr;
    NSArray *_dataArr;
    NSMutableArray *_itemArr;
    UIButton *_dataDetailBtn;
}
@property(nonatomic, strong)UIImageView *dataIcon;
@property(nonatomic, strong)UIImageView *nextIcon;
@property(nonatomic, strong)UILabel *dataDesc;
@property(nonatomic, strong)UILabel *desc;
@property(nonatomic, strong)UILabel *desc1;

@end
@implementation GMServiceDataView
- (void)setup {
    [super setup];
    
    _descArr = @[@"服务分", @"在线时长", @"有效面诊次数", @"好评率", @"接通率", @"有效面诊人数"];
    _dataArr = @[@"--", @"0h", @"0", @"0", @"0", @"0"];
    _itemArr = [NSMutableArray array];
    
    _dataIcon = [[GMImageView alloc] init];
    _dataIcon.image = [UIImage imageNamed:@"wt_data_icon"];
    _dataIcon.layer.cornerRadius = 8;
    _dataIcon.layer.masksToBounds = YES;
    [self addSubview:_dataIcon];
    
    [_dataIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(16, 16));
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(3);
    }];
    
    _dataDesc = [[UILabel alloc] init];
    _dataDesc.text = @"服务数据";
    _dataDesc.textColor = RGBCOLOR_HEX(0x282828);
    _dataDesc.textAlignment = NSTextAlignmentCenter;
    _dataDesc.font = [UIFont gmBoldFont:16];
    [self addSubview:_dataDesc];
    [_dataDesc mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_dataIcon.mas_centerY);
        make.left.mas_equalTo(_dataIcon.mas_right).offset(8);
        make.width.mas_equalTo(64);
        make.height.mas_equalTo(22);
    }];
    
    _desc = [[UILabel alloc] init];
    _desc.text = @"（当天）";
    _desc.textColor = RGBCOLOR_HEX(0x909399);
    _desc.textAlignment = NSTextAlignmentCenter;
    _desc.font = [UIFont gmFont:14];
    [self addSubview:_desc];
    [_desc mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_dataDesc.mas_centerY);
        make.left.mas_equalTo(_dataDesc.mas_right).offset(5);
        make.width.mas_equalTo(56);
        make.height.mas_equalTo(20);
    }];
    
    _nextIcon = [[GMImageView alloc] init];
    _nextIcon.image = [UIImage imageNamed:@"wt_data_detail_next"];
    [self addSubview:_nextIcon];
    
    [_nextIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(12, 12));
        make.right.mas_equalTo(-15);
        make.centerY.mas_equalTo(_dataDesc.mas_centerY);
    }];
    
    _desc1 = [[UILabel alloc] init];
    _desc1.text = @"明细";
    _desc1.textColor = RGBCOLOR_HEX(0x909399);
    _desc1.textAlignment = NSTextAlignmentRight;
    _desc1.font = [UIFont gmFont:14];
    [self addSubview:_desc1];
    [_desc1 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_dataDesc.mas_centerY);
        make.right.mas_equalTo(_nextIcon.mas_left).offset(-5);
        make.width.mas_equalTo(35);
        make.height.mas_equalTo(20);
    }];
    
    _dataDetailBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_dataDetailBtn addTarget:self action:@selector(dataDetailBtn:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_dataDetailBtn];
    
    [_dataDetailBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_dataDesc.mas_centerY);
        make.right.mas_equalTo(self);
        make.left.mas_equalTo(_desc1.mas_left);
    }];
    
    for (int i = 0; i < _descArr.count; i++) {
        GMServiceDataItemView *item = [[GMServiceDataItemView alloc] initWithFrame:CGRectZero];
        item.descLabel.text = _descArr[i];
        item.dataLabel.text = _dataArr[i];
        [self addSubview:item];
        [_itemArr addObject:item];
        
        int m = i % 3;
        int n = i / 3;
        
        if (m == 2) {
            item.line.hidden = YES;
        }
        
        [item mas_makeConstraints:^(MASConstraintMaker *make) {
            if (n > 0) {
                make.top.mas_equalTo(_dataDesc.mas_bottom).offset(77);
            } else {
                make.top.mas_equalTo(_dataDesc.mas_bottom);
            }
            make.left.mas_equalTo(m * MAINSCREEN_WIDTH / 3.0);
            make.width.mas_equalTo(MAINSCREEN_WIDTH / 3.0);
            make.height.mas_equalTo(77);
        }];
    }
    
    _bottomLabel = [[UILabel alloc] init];
    _bottomLabel.text = @"公告区";
    _bottomLabel.textColor = RGBCOLOR_HEX(0x909399);
    _bottomLabel.textAlignment = NSTextAlignmentCenter;
    _bottomLabel.font = [UIFont gmBoldFont:12];
    [self addSubview:_bottomLabel];
    [_bottomLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.mas_bottom);
        make.centerX.mas_equalTo(self.mas_centerX);
        make.width.mas_equalTo(36);
        make.height.mas_equalTo(16);
    }];
    
    _leftLine = [[UILabel alloc] init];
    _leftLine.backgroundColor = RGBCOLOR_HEX(0xEEEEEE);
    [self addSubview:_leftLine];
    [_leftLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_bottomLabel.mas_centerY);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(_bottomLabel.mas_left).offset(-22);
        make.height.mas_equalTo(ONE_PIXEL);
    }];
    
    _rightLine = [[UILabel alloc] init];
    _rightLine.backgroundColor = RGBCOLOR_HEX(0xEEEEEE);
    [self addSubview:_rightLine];
    [_rightLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_bottomLabel.mas_centerY);
        make.right.mas_equalTo(-15);
        make.left.mas_equalTo(_bottomLabel.mas_right).offset(22);
        make.height.mas_equalTo(ONE_PIXEL);
    }];
}

- (void)setWorkTableObject:(GMWorkTableObject *)workTableObject {
    _workTableObject = workTableObject;
    NSArray *texts = [NSArray arrayWithObjects:([workTableObject.stars isNonEmpty] ? workTableObject.stars : @"--"), SafeString(workTableObject.onlineTime), SafeString(workTableObject.users), ([workTableObject.likeRate isNonEmpty] ? workTableObject.likeRate : @"0"), ([workTableObject.connectRate isNonEmpty] ? workTableObject.connectRate : @"0"), ([workTableObject.consultPeopleNumber isNonEmpty] ? workTableObject.consultPeopleNumber : @"0"), nil];
    int i = 0;
    for (GMServiceDataItemView *item in _itemArr) {
        item.dataLabel.text = texts[i];
        i++;
    }
}

// 数据明细
- (void)dataDetailBtn:(UIButton *)sender {
    if (self.dataDetailClickBlock) {
        self.dataDetailClickBlock();
    }
}

@end


@interface GMDiagnosisWorkingTableHeaderView()<UICollectionViewDelegate, UICollectionViewDataSource, GMGMDiagnosisWorkingTableScrollViewDelegate>

@property(nonatomic, strong)GMCollectionView *functionCollection;
@property(nonatomic, strong)UIImageView *notifyIcon;
@property(nonatomic, strong)GMServiceDataView *serviceDataView;
@property(nonatomic, strong)GMGMDiagnosisWorkingTableScrollView *scrollView;
@property(nonatomic, strong)UIImageView *dataIcon;

@end

@implementation GMDiagnosisWorkingTableHeaderView
- (instancetype)initWithFrame:(CGRect)frame {
    if (self == [super initWithFrame:frame]) {
        self.backgroundColor = [UIColor whiteColor];
        [self setup];
    }
    return self;
}

- (void)setup {
    [super setup];
    
    _notifyIcon = [[GMImageView alloc] init];
    _notifyIcon.image = [UIImage imageNamed:@"wt_notify_icon"];
    _notifyIcon.layer.cornerRadius = 8;
    _notifyIcon.layer.masksToBounds = YES;
    [self addSubview:_notifyIcon];
    
    [_notifyIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(16, 16));
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(30);
    }];
    
    [self addSubview: self.scrollView];
    [_scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(21);
        make.left.mas_equalTo(_notifyIcon.mas_right).offset(8);
        make.centerY.mas_equalTo(_notifyIcon.mas_centerY);
    }];
    
    [self addSubview: self.functionCollection];
    [_functionCollection mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(0);
        make.height.mas_equalTo(110);
        make.left.mas_equalTo(_scrollView.mas_left);
        make.top.mas_equalTo(_notifyIcon.mas_bottom);
    }];
    
    [self addSubview: self.serviceDataView];
    [_serviceDataView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(MAINSCREEN_WIDTH);
        make.height.mas_equalTo(193);
        make.left.mas_equalTo(0);
        make.top.mas_equalTo(_functionCollection.mas_bottom);
    }];
    
    UIView *hideView = [[UIView alloc]init];
    hideView.backgroundColor = UIColor.whiteColor;
    [self addSubview:hideView];
    [hideView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(MAINSCREEN_WIDTH, 28));
        make.left.mas_equalTo(0);
        make.top.mas_equalTo(0);
    }];
}

- (void)setWorkTableObject:(GMWorkTableObject *)workTableObject {
    _workTableObject = workTableObject;
    [self.functionCollection reloadData];
    
    self.serviceDataView.workTableObject = workTableObject;
    
    NSMutableArray *contentArr = [NSMutableArray array];
    [contentArr addObject:[self scrollItemStr:[NSString stringWithFormat:@"%@份", workTableObject.reportsToWrite] leftStr:@"你有" rightStr:@"待写的面诊报告"]];
    [contentArr addObject:[self scrollItemStr:[NSString stringWithFormat:@"%@个", workTableObject.miss] leftStr:@"你今天错过了" rightStr:@"用户"]];
    self.scrollView.dataSource = contentArr;

}

- (NSMutableAttributedString *)scrollItemStr:(NSString *)string leftStr:(NSString *)leftStr rightStr:(NSString *)rightStr {
    NSMutableAttributedString *content = [[NSMutableAttributedString alloc] init];
    NSAttributedString *subContentA = [[NSAttributedString alloc] initWithString:leftStr attributes:@{NSFontAttributeName: [UIFont gmBoldFont:15], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)}];
    NSAttributedString *subContent = [[NSAttributedString alloc] initWithString:string attributes:@{NSFontAttributeName: [UIFont gmBoldFont:15], NSForegroundColorAttributeName: RGBCOLOR_HEX(0xFF8C8D)}];

    NSAttributedString *subContentB = [[NSAttributedString alloc] initWithString:rightStr attributes:@{NSFontAttributeName: [UIFont gmBoldFont:15], NSForegroundColorAttributeName: RGBCOLOR_HEX(0x282828)}];
    [content appendAttributedString: subContentA];
    [content appendAttributedString: subContent];
    [content appendAttributedString: subContentB];
    return content;
}

- (void)gotoDataDetalsWithType:(int)type {
    if (type == 0) { // 跳转至「面诊报告-面诊报告列表」页面
        NSString *url = [NSString stringWithFormat:@"gengmei://%@?counsellor_id=%@", HOST_PUSH_REPORT_LIST, self.doctorId];
        [[GMRouter sharedInstance] pushScheme:url];
    }
}

#pragma mark -- UICollectionViewDelegate
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section{
    return self.workTableObject.iconList.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    GMWoikingTableCollectionCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"GMWoikingTableCollectionCell" forIndexPath:indexPath];
    GMWorkTableIconObject *obj = self.workTableObject.iconList[indexPath.row];
    cell.infoLabel.text = obj.text;
    cell.badge.text = obj.badge;
    cell.badge.hidden = !obj.badge.isNonEmpty;
    [cell.icon sd_setImageWithURL:[NSURL URLWithString:obj.icon]];
    return cell;
}

- (CGSize)collectionView:(UICollectionView *)collectionView
                  layout:(UICollectionViewLayout *)collectionViewLayout
  sizeForItemAtIndexPath:(NSIndexPath *)indexPath{
    return CGSizeMake(56, 68);
}

- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section{
    return UIEdgeInsetsMake(18, 0, -24, 0);
}

//动态设置每行的间距大小
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section {
    return 13;
}

//动态设置每列的间距大小
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section {
    return 20;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath{
    // 跳转至「面诊报告-面诊报告列表」页面
//    NSString *url = [NSString stringWithFormat:@"gengmei://%@?doctor_id=%@", HOST_PUSH_REPORT_LIST, self.doctorId];
    GMWorkTableIconObject *obj = self.workTableObject.iconList[indexPath.row];
    [[GMRouter sharedInstance] pushScheme:obj.url];
}

- (GMCollectionView *)functionCollection {
    if (!_functionCollection) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
        _functionCollection = [[GMCollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        [_functionCollection registerCell:[GMWoikingTableCollectionCell class]];
        _functionCollection.backgroundColor = [UIColor whiteColor];
        _functionCollection.delegate = self;
        _functionCollection.dataSource = self;
    }
    return _functionCollection;
}

- (GMServiceDataView *)serviceDataView {
    if (!_serviceDataView) {
        _serviceDataView = [[GMServiceDataView alloc] initWithFrame:CGRectZero];
        __weak typeof(self) weakSelf = self;
        _serviceDataView.dataDetailClickBlock = ^{
            // 数据明细
//            NSString *url = [NSString stringWithFormat:@"gengmei://common_webview?url=%@/phantom/treatment/business/data/detail?doctor_id=%@", GMServerDomains.apiHost, weakSelf.doctorId];
            [[GMRouter sharedInstance] pushScheme:weakSelf.workTableObject.serverDataDetailUrl];
        };
    }
    return _serviceDataView;
}

- (GMGMDiagnosisWorkingTableScrollView *)scrollView {
    if (!_scrollView) {
        _scrollView = [[GMGMDiagnosisWorkingTableScrollView alloc] initWithFrame:CGRectZero];
        NSMutableArray *contentArr = [NSMutableArray array];
        [contentArr addObject:[self scrollItemStr:@"0份" leftStr:@"你有" rightStr:@"待写的面诊报告"]];
        [contentArr addObject:[self scrollItemStr:@"0个" leftStr:@"你今天错过了" rightStr:@"用户"]];
        _scrollView.dataSource = contentArr;
        _scrollView.clickDelegate = self;
    }
    return _scrollView;
}

@end
