//
//  GMDiagnosisWorkingTableSwitch.m
//  Gengmei
//
//  Created by Jessica on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnosisWorkingTableSwitch.h"

@implementation GMDiagnosisWorkingTableSwitch
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.userInteractionEnabled = YES;
        self.isSelected = NO;
        self.image = [UIImage imageNamed: @"wt_unopen"];
        UITapGestureRecognizer *tapAction = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(clickFloatImage)];
        [self addGestureRecognizer:tapAction];
    }
    return self;
}

- (CGSize)intrinsicContentSize {
    return CGSizeMake(80, 80);
}

- (void)setIsSelected:(BOOL)isSelected {
    _isSelected = isSelected;
    self.image = [UIImage imageNamed:_isSelected ? @"wt_open" : @"wt_unopen"];
}

- (void)clickFloatImage {
    if ([self.delegate respondsToSelector:@selector(diagnosisWorkingTableSwitchDidSelectedWithStatus:successBlock:)]) {
        [self.delegate diagnosisWorkingTableSwitchDidSelectedWithStatus: self.isSelected ? DiagnosisWorkingTableSwitchStatusOff : DiagnosisWorkingTableSwitchStatusOn successBlock:^(BOOL isSuccess) {
            if (isSuccess) {
                self.isSelected = !self.isSelected;
            }
            
        }];
    }
    
}

@end
