//
//  GMEditQuesPartCell.m
//  Gengmei
//
//  Created by Locus on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMEditQuesPartCell.h"

@interface GMEditQuesPartCell ()

@property (nonatomic, strong) GMLabel *descLabel;

@end

@implementation GMEditQuesPartCell

- (void)setup {
    [super setup];
    self.descLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:17];
    self.descLabel.font = [UIFont gmBoldFont:17];
    [self.contentView addSubview:self.descLabel];
    [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_offset(41);
        make.left.mas_offset(16);
        make.height.mas_offset(24);
        make.right.mas_offset(-37);
    }];
    
    UIImageView *arrowImageV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"arrow_mybooklist"]];
    [self.contentView addSubview:arrowImageV];
    [arrowImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(6.4, 13));
        make.right.mas_offset(-26);
        make.centerY.mas_equalTo(self.descLabel);
    }];
    
    self.titleLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:15];
    [self.contentView addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_offset(21);
        make.top.mas_offset(14);
        make.left.mas_offset(16);
    }];
    
    [self updateBottomLineConstraintsWithLeft:16 right:-16];
}

- (void)setType:(GMEditQuesPartType)type {
    _type = type;
    if (type == GMEditQuesPartTypeSectionTag) {
        self.titleLabel.text = @"问题部位";
    } else if (type == GMEditQuesPartTypeImproveAppeal) {
        self.titleLabel.text = @"改善述求";
    } else if (type == GMEditQuesPartTypeSuitProject) {
       self.titleLabel.text = @"适应项目";
    }
}

- (void)setDesc:(NSString *)desc {
    _desc = desc;
    self.descLabel.text = [desc isNonEmpty] ? desc : @"请选择";
    self.descLabel.textColor = [desc isNonEmpty] ? UIColor.headlineText : UIColor.auxiliaryTextLight;
}

@end
