//
//  GMEditQuesSuggestCell.m
//  Gengmei
//
//  Created by Locus on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMEditQuesSuggestCell.h"

@interface GMEditQuesSuggestCell () <UITextViewDelegate>

@property (nonatomic, strong) GMLabel *countLabel;

@end

@implementation GMEditQuesSuggestCell

- (void)setup {
    [super setup];
    self.bottomLine.hidden = YES;
    GMLabel *titleLabel = [GMLabel labelWithTextColor:UIColor.headlineText fontSize:15];
    titleLabel.text = @"其他建议";
    [self.contentView addSubview:titleLabel];
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_offset(21);
        make.top.mas_offset(14);
        make.left.mas_offset(16);
    }];
    
    UIImageView *bgImageV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"to_face_edit_ques_suggest_bg"]];
    [self.contentView addSubview:bgImageV];
    [bgImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_offset(53);
        make.left.mas_offset(20);
        make.right.mas_offset(-20);
        make.bottom.mas_offset(0);
    }];
    
    [self.contentView addSubview:self.textView];
    [self.textView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(bgImageV).insets(UIEdgeInsetsMake(0, 10, 34, 10));
    }];
    
    [self.contentView addSubview:self.countLabel];
    [self.countLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_offset(-10);
        make.right.mas_offset(-30);
    }];
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    NSString *string = [textView.text stringByReplacingCharactersInRange:range withString:text];
    if (string.length > 200) {
        return NO;
    }
    return YES;
}

- (void)textViewDidChange:(UITextView *)textView {
    _countLabel.text = [NSString stringWithFormat:@"还能输入%d字", MAX((200 - textView.text.length), 0)];
}

- (GMPlaceholderTextContainer *)textView {
    if (!_textView) {
        _textView = [[GMPlaceholderTextContainer alloc] init];
        _textView.textView.delegate = self;
        _textView.textView.font = [UIFont gmFont:14];
        _textView.placeholder = @"选填报表，补充信息等";
        _textView.placeholderLabel.font = [UIFont gmFont:14];
        _textView.placeholderLabel.textColor = UIColor.auxiliaryTextExtraLight;
        _textView.textView.textColor = UIColor.headlineText;
        _textView.textView.inputAccessoryView = nil;
    }
    return _textView;
}

- (GMLabel *)countLabel {
    if (!_countLabel) {
        _countLabel = [GMLabel labelWithTextColor:UIColor.auxiliaryTextExtraLight fontSize:10];
        _countLabel.text = @"还能输入200字";
    }
    return _countLabel;
}

@end
