//
//  GMGrabedListCell.m
//  Gengmei
//
//  Created by Jessica on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMGrabedListCell.h"

@implementation GMGrabedListCell
- (void)setup {
    [super setup];
    
    self.bottomLine.hidden = YES;
    
    GMImageView *bgImage = [[GMImageView alloc] init];
    bgImage.image = [UIImage imageNamed:@"wt_grabed_bg"];
    bgImage.userInteractionEnabled = YES;
    [self.contentView addSubview:bgImage];
    [bgImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(UIEdgeInsetsMake(0, 5, 0, 5));
    }];
    
    _statusImage = [[GMImageView alloc] init];
    _statusImage.image = [UIImage imageNamed:@"wt_grab_done"];
    _statusImage.hidden = YES;
    [bgImage addSubview:_statusImage];
    
    [_statusImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(86, 50));
        make.right.mas_equalTo(0);
        make.top.mas_equalTo(24);
        make.bottom.mas_equalTo(-24);
    }];
    
    _infoView = [[GMDiagnosisDispatchInfoView alloc] init];
    [bgImage addSubview:_infoView];
    
    [_infoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(_statusImage.mas_centerY);
        make.left.mas_equalTo(25);
        make.right.mas_lessThanOrEqualTo(_statusImage.mas_left).offset(10);
    }];
    
}

- (void)updateConstraints {
    [super updateConstraints];
    
}
@end
