//
//  GMIsDoctorPopupView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/2/22.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMIsDoctorPopupView.h"
#import "GMEndConsultView.h"
#import "GMToFaceNetworking.h"
#import <GMBase/GMBaseTool.h>


@import GMKit;
@import GMHud;

@interface GMIsDoctorPopupView ()
@property (nonatomic, strong) UIView *grayLineView;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMButton *cancelButton;
@property (nonatomic, strong) GMButton *sureButton;
/// 不是
@property (nonatomic, strong) GMButton *negateButton;
/// 面诊id
@property (nonatomic, copy) NSString *diagnosisId;
@end

@implementation GMIsDoctorPopupView
- (instancetype)initWithDiagnosisId:(NSString *)diagnosisId {
    if (self = [super init]) {
        self.diagnosisId = diagnosisId;
    }
    return self;
}
- (void)setup {
    [super setup];
    [self setUI];
    [self setLayout];
    [self containerRectCorner:self.container];
}
- (void)containerRectCorner:(UIView *)view {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:view.bounds byRoundingCorners:UIRectCornerTopLeft | UIRectCornerTopRight cornerRadii:CGSizeMake(12, 12)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = view.bounds;
    maskLayer.path = maskPath.CGPath;
    view.layer.mask = maskLayer;
}
- (void)setUI {
    [self.container addSubview:self.grayLineView];
    [self.container addSubview:self.titleLabel];
    [self.container addSubview:self.cancelButton];
    [self.container addSubview:self.sureButton];
    [self.container addSubview:self.negateButton];
}
- (void)setLayout {
    [self.grayLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_offset(0);
        make.top.mas_equalTo(10);
        make.size.mas_equalTo(CGSizeMake(50, 5));
    }];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_offset(0);
        make.top.mas_offset(55);
        make.size.mas_offset(CGSizeMake(MAINSCREEN_WIDTH, 22));
    }];
    [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(12, 12));
        make.top.mas_offset(24);
        make.right.mas_offset(-24);
    }];
    [self.sureButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.container.mas_centerX).offset(-10);
        make.top.mas_offset(110);
        make.size.mas_offset(CGSizeMake(136, 45));
    }];
    [self.negateButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(136, 45));
        make.top.mas_offset(110);
        make.left.equalTo(self.container.mas_centerX).offset(10);
    }];
    [self.container mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.mas_equalTo(0);
        make.height.mas_equalTo(198);
    }];
}
- (void)judgeIsDoctorMethod:(GMButton *)sender {
    //判断是否是医生本人
    [self showLoading];
    __weak __typeof(self)weakSelf = self;
    [[GMToFaceNetworking shareInstance] excuteToFaceIsSureDoctor:sender.tag diagnosis_id:self.diagnosisId SuccessBlock:^(id response) {
        [weakSelf hideLoading];
        [weakSelf hide];
        [weakSelf evaluateDoctor];
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        [weakSelf hideLoading];
        [weakSelf hide];
        [GMHudModule toastInView:[UIApplication sharedApplication].keyWindow text:message];
        [weakSelf evaluateDoctor];
    }];
}
#pragma mark - 评价医生
- (void)evaluateDoctor {
    __weak __typeof(self)weakSelf = self;
    [[GMToFaceNetworking shareInstance] excuteToFaceEvaluateItemDiagnosis_id:weakSelf.diagnosisId SuccessBlock:^(id response) {
        GMStarWithContentObject *starContentModel = [[GMStarWithContentObject alloc] initWithDictionary:response error:nil];
        GMEndConsultView *view = [[GMEndConsultView alloc] initWithType:(GMEndConsultViewTypeGrayStar) starNum:0];
        view.recordId = weakSelf.diagnosisId;
        view.starContentArray = starContentModel.evaluates;
        [[GMBaseTool mainWindow]  addSubview:view];
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        
    }];
}
- (void)didTapView {
    [self hide];
    [self evaluateDoctor];
}
- (void)clickCancel {
    [self hide];
    [self evaluateDoctor];
}
- (void)showLoading {
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:[UIApplication sharedApplication].keyWindow animated:YES];
    hud.mode = MBProgressHUDModeIndeterminate;
    hud.labelText = nil;
}
- (void)hideLoading {
    [MBProgressHUD hideHUDForView:[UIApplication sharedApplication].keyWindow animated:YES];
}
- (UIView *)grayLineView {
    if (!_grayLineView) {
        _grayLineView = [[UIView alloc] init];
        _grayLineView.backgroundColor = RGBCOLOR_HEX(0xEEEEEE);
        _grayLineView.layer.cornerRadius = 2.5f;
        _grayLineView.layer.masksToBounds = YES;
    }
    return _grayLineView;
}
- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:16];
        _titleLabel.textAlignment = NSTextAlignmentCenter;
        _titleLabel.text = @"本次视频面诊是否为医生本人？";
    }
    return _titleLabel;
}
- (GMButton *)cancelButton {
    if (!_cancelButton) {
        _cancelButton = [GMButton buttonWithType:UIButtonTypeCustom];
        _cancelButton.enableAdaptive = YES;
        [_cancelButton setBackgroundImage:[UIImage imageNamed:@"doubleeye_cancel_pre"] forState:UIControlStateNormal];
        [_cancelButton addTarget:self action:@selector(clickCancel) forControlEvents:UIControlEventTouchUpInside];
    }
    return _cancelButton;
}
- (GMButton *)sureButton {
    if (!_sureButton) {
        _sureButton = [GMButton buttonWithType:(UIButtonTypeCustom)];
        _sureButton.tag = 1;
        [_sureButton setTitle:@"是" forState:(UIControlStateNormal)];
        [_sureButton setBackgroundColor:RGBCOLOR_HEX(0x4DBBB5) forState:(UIControlStateNormal)];
        [_sureButton setTitleColor:UIColor.whiteColor forState:(UIControlStateNormal)];
        [_sureButton addTarget:self action:@selector(judgeIsDoctorMethod:) forControlEvents:(UIControlEventTouchUpInside)];
        _sureButton.layer.cornerRadius = 22.5f;
        _sureButton.layer.masksToBounds = YES;
    }
    return _sureButton;
}
- (GMButton *)negateButton {
    if (!_negateButton) {
        _negateButton = [GMButton buttonWithType:(UIButtonTypeCustom)];
        _negateButton.tag = 0;
        [_negateButton setTitle:@"不是" forState:(UIControlStateNormal)];
        [_negateButton setBackgroundColor:RGBCOLOR_HEX(0xD8D8D8) forState:(UIControlStateNormal)];
        [_negateButton setTitleColor:UIColor.whiteColor forState:(UIControlStateNormal)];
        [_negateButton addTarget:self action:@selector(judgeIsDoctorMethod:) forControlEvents:(UIControlEventTouchUpInside)];
        _negateButton.layer.cornerRadius = 22.5f;
        _negateButton.layer.masksToBounds = YES;
    }
    return _negateButton;
}
@end
