//
//  GMMissUsersTipView.m
//  Gengmei
//
//  Created by Jessica on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMMissUsersTipView.h"
#import "GMLibraryHeader.h"

@interface GMMissUsersTipView()
@property(nonatomic, strong) GMImageView *imageView;
@property(nonatomic, strong) GMLabel *contentLabel;

@end
@implementation GMMissUsersTipView
-(void)setup{
    [super setup];
    self.animationType = GMPopupAnimationTypeNone;
    // 设置 container
    self.container.backgroundColor = [UIColor colorWithHex:000000 alpha:0];
    self.bgAlphaColor = [UIColor colorWithHex:000000 alpha:0];
    [self.container mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];

    // imageView
    _imageView = [[GMImageView alloc] initWithImage:[UIImage imageNamed:@"wt_tip_trangle"]];
    _imageView.mj_size = CGSizeMake(14, 7);
    [self.container addSubview:_imageView];
    
    _contentLabel = [[GMLabel alloc] init];
    _contentLabel.layer.cornerRadius = 14;
    _contentLabel.layer.masksToBounds = YES;
    _contentLabel.text = @"视频面诊拨打5s以上并未接通的用户";
    _contentLabel.backgroundColor = [UIColor colorWithHex:000000 alpha:0.5];
    _contentLabel.textColor = UIColor.whiteColor;
    _contentLabel.textAlignment = NSTextAlignmentCenter;
    _contentLabel.font = [UIFont gmFont:12];
    _contentLabel.paddingEdge = UIEdgeInsetsMake(5, 10, 5, 10);
    [self addSubview:_contentLabel];

    // 添加点击效果
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hide)];
    [self addGestureRecognizer:tap];
}

- (void)setItemFrame:(CGRect)itemFrame {
    _itemFrame = itemFrame;
    
    _imageView.mj_y = itemFrame.origin.y + itemFrame.size.height;
    _imageView.centerX = itemFrame.size.width + itemFrame.origin.x - 7;
    
    [_contentLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(_imageView.mas_centerX);
        make.top.mas_equalTo(_imageView.mas_bottom);
    }];
}

- (void)hide {
    [self removeFromSuperview];
    if ([self.hideDelegate respondsToSelector:@selector(missUsersTipViewHide)]) {
        [self.hideDelegate missUsersTipViewHide];
    }
}


@end
