//
//  GMOnlineStatusView.m
//  Gengmei
//
//  Created by Jessica on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMOnlineStatusView.h"
@import GMBase;

@interface GMOnlineStatusView()
@property(nonatomic, copy) NSString *desc;
@end

@implementation GMOnlineStatusView
- (instancetype)initWithFrame:(CGRect)frame desc:(NSString *)desc {
    self.desc = desc;
    if (self == [super initWithFrame:frame]) {
        return self;
    }
    return [[GMOnlineStatusView alloc] initWithFrame:frame];
}

-(void)setup {
    [super setup];
    
    UILabel *statusLabel = [[UILabel alloc] init];
    statusLabel.backgroundColor = RGBCOLOR_HEX(0x20BDBB);
    statusLabel.layer.cornerRadius = 2 + ONE_PIXEL;
    statusLabel.layer.masksToBounds = YES;
    [self addSubview:statusLabel];
    
    [statusLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(5, 5));
    }];
    
    _descLabel = [[UILabel alloc] init];
    _descLabel.font = [UIFont gmFont:11];
    _descLabel.textColor = RGBCOLOR_HEX(0x999999);
    _descLabel.text = self.desc;
    [self addSubview:_descLabel];
    [_descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(statusLabel.mas_right).offset(4);
        make.centerY.mas_equalTo(statusLabel.mas_centerY);
        make.height.mas_equalTo(15);
        make.right.mas_equalTo(0);
    }];
}

@end
