//
//  GMWaitingGrabListCell.m
//  Gengmei
//
//  Created by Jessica on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMWaitingGrabListCell.h"
#import "GMTelephoneProxy.h"
@import GMBase;

@interface GMWaitingGrabListCell() {
    GMImageView *_bgImage;
}
@property (nonatomic, strong) NSTimer *timer;
@property (nonatomic, assign) CGFloat lastTime;
@property (nonatomic, assign) CGFloat maxTime;

@end

@implementation GMWaitingGrabListCell
- (void)setup {
    [super setup];
    
    self.bottomLine.hidden = YES;
    
    _bgImage = [[GMImageView alloc] init];
    _bgImage.image = [UIImage imageNamed:@"wt_grab_bg"];
    _bgImage.userInteractionEnabled = YES;
    [self.contentView addSubview:_bgImage];
    [_bgImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(UIEdgeInsetsMake(0, 0, 0, 0));
    }];
    
    _progressView = [[GMGradientProgressView alloc] initWithFrame:CGRectMake(10, 6, MAINSCREEN_WIDTH - 20, 4)];
    _progressView.colorArr = @[(id)[UIColor colorWithHexString:@"FFC356"].CGColor, (id)[UIColor colorWithHexString:@"FF4766"].CGColor];
    [_bgImage addSubview:_progressView];
//    [_progressView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.right.mas_equalTo(0);
//        make.top.mas_equalTo(0);
//        make.height.mas_equalTo(4);
//    }];
    
    _sameCityImage = [[GMImageView alloc] init];
    _sameCityImage.image = [UIImage imageNamed:@"wt_same_city_icon"];
    [_bgImage addSubview:_sameCityImage];
    
    [_sameCityImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(36, 20));
        make.left.mas_equalTo(_bgImage.mas_left).offset(25);
        make.top.mas_equalTo(_bgImage.mas_top).offset(26);
    }];
    
    _grabBtn = [GMButton new];
    [_grabBtn setImage:[UIImage imageNamed:@"wt_can_select_grab_icon"] forState:UIControlStateNormal];
    [_grabBtn addTarget:self action:@selector(grabBtnAction:) forControlEvents:UIControlEventTouchUpInside];
//    _grabBtn.userInteractionEnabled = NO;
    
//    [_grabBtn setBackgroundColor:GMColorD5D5D5 forState:UIControlStateNormal];
    [_bgImage addSubview:_grabBtn];
    [_grabBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(60, 60));
        make.right.mas_equalTo(-25);
        make.top.mas_equalTo(22);
        make.bottom.mas_equalTo(-22);
    }];
    
    _infoView = [[GMDiagnosisDispatchInfoView alloc] init];
    [_bgImage addSubview:_infoView];
    
    [_infoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_sameCityImage.mas_bottom).offset(7);
        make.left.mas_equalTo(25);
        make.right.mas_lessThanOrEqualTo(_grabBtn.mas_left).offset(10);
    }];
    
}

- (void)updateConstraints {
    [super updateConstraints];
    _sameCityImage.hidden = !_isShowSameCity;
    if (_isShowSameCity) {
        [_grabBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(60, 60));
            make.right.mas_equalTo(-25);
            make.centerY.mas_equalTo(_bgImage.mas_centerY);
        }];
        
        [_infoView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(_sameCityImage.mas_bottom).offset(7);
            make.left.mas_equalTo(25);
            make.right.mas_lessThanOrEqualTo(_grabBtn.mas_left).offset(10);
            make.bottom.mas_greaterThanOrEqualTo(_bgImage.mas_bottom).offset(-36);
        }];
    } else {
        [_grabBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(60, 60));
            make.right.mas_equalTo(-25);
            make.top.mas_equalTo(22);
            make.bottom.mas_equalTo(-22);
        }];
        
        [_infoView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_equalTo(_grabBtn.mas_centerY);
            make.left.mas_equalTo(25);
            make.right.mas_lessThanOrEqualTo(_grabBtn.mas_left).offset(10);
        }];
    }
}

- (void)begainTimerWithRemainingTime:(NSInteger)remainingTime maxTime:(NSInteger)maxTime {
    if (self.timer.valid) {
        [self invalidateTimer];
    }
    
    // 剩余时间为0
    if (remainingTime <= 0) {
        _progressView.progress = 0;
        return;
    }
    
    [self updateGrabBtnStatusWithCanClicked:YES];
    _maxTime = maxTime;
    _lastTime = maxTime - remainingTime;
    
//    // 这句话重点,加这行代码可以让程序在后台运行一段时间
//    [[UIApplication sharedApplication] beginBackgroundTaskWithExpirationHandler:nil];

    self.timer = [NSTimer timerWithTimeInterval:0.1 target:[GMTelephoneProxy proxyWithTarget:self] selector:@selector(updateProgress) userInfo:nil repeats:YES];
    [[NSRunLoop mainRunLoop] addTimer:self.timer forMode:NSRunLoopCommonModes];
}

- (void)updateProgress {
    _lastTime++;
    // 实时更新剩余时间
    _object.countdown = _maxTime - _lastTime;
    if (_lastTime <= _maxTime) {
        _progressView.progress = 1 - _lastTime / _maxTime;
    } else {
        // 超过后则没有抢单资质，抢单按钮置灰
        [self updateGrabBtnStatusWithCanClicked:NO];
    }
}

- (void)updateGrabBtnStatusWithCanClicked:(BOOL)canClicked {
    if (canClicked) {
        self.grabBtn.userInteractionEnabled = YES;
        [self.grabBtn setImage:[UIImage imageNamed:@"wt_can_select_grab_icon"] forState:UIControlStateNormal];
    } else {
        [self invalidateTimer];
        self.grabBtn.userInteractionEnabled = NO;
        [self.grabBtn setImage:[UIImage imageNamed:@"wt_selected_grab_icon"] forState:UIControlStateNormal];
        _progressView.progress = 0;
    }
}

- (void)invalidateTimer {
    [self.timer invalidate];
    self.timer = nil;
    _lastTime = 0;
}

#pragma mark - 点击抢单
- (void)grabBtnAction:(GMButton *)sender {
    if (self.grabBtnClicked) {
        self.grabBtnClicked();
    }
}

-(void)dealloc {
    [self invalidateTimer];
}
@end
