//
//  GMBusinessReportResultController.m
//  Gengmei
//
//  Created by Locus on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMBusinessReportResultController.h"
#import "QiniuSDK.h"
#import "RequestHeader.h"
#import <GMBaseWeb/GMBaseWeb-Swift.h>

@import GMNetworking;
@import GMFoundation;
@interface GMBusinessReportResultController () <WKWebViewDelegate>

@property (nonatomic, strong) UIImage *shareImage;
@property (nonatomic, copy) NSString *shareUserId;
@property (nonatomic, copy) NSString *qiniuKey;

@end

@implementation GMBusinessReportResultController

- (void)initController {
    [super initController];
    self.navigationBar.title = @"面诊报告";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.webCompent.delegate = self;
    self.fd_interactivePopDisabled = YES;
    self.navigationBar.isShowShadow = YES;
    self.path = API_TREETMENT_BUSINESS_REPORT_RESULT;
    [self reloadURL];
}

- (NSString *)moreQueryParameters {
    return [NSString stringWithFormat:@"&record_id=%@",SafeString(self.recordId)];
}

- (void)shareBase64ImageMethod:(NSString *)imageDataStr {
    if (!self.qiniuKey) {
        NSData *jsonData = [imageDataStr dataUsingEncoding:NSUTF8StringEncoding];
        NSDictionary *dict = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingMutableContainers error:nil];
        NSString *imageString = dict[@"imageString"] ?: @"";
        if (![imageString isNonEmpty]) {
            return;
        }
        self.recordId = SafeString(dict[@"recordId"]);
        self.shareUserId = SafeString(dict[@"userId"]);
        self.shareImage = [UIImage imageWithData:[[NSData alloc] initWithBase64EncodedString:imageString options:NSDataBase64DecodingIgnoreUnknownCharacters]];
        __block NSString *key = [[GMUploadImagesManager shareInstance] createImagePath];
        [[GMUploadImagesManager shareInstance] getTokenWithType:GMTokenTypeImage resultBlock:^(BOOL result, NSString *message) {
            if (result) {
                NSData *imageData = UIImageJPEGRepresentation(self.shareImage, 1);
                QNUploadManager *upManager = [[QNUploadManager alloc] init];
                [upManager putData:imageData key:key token:message complete:^(QNResponseInfo *info, NSString *key, NSDictionary *resp) {
                    if (info.isOK) {
                        self.qiniuKey = key;
                        [self sendMessage];
                    }
                } option:nil];
            }
        }];
    } else {
        [self sendMessage];
    }
}

- (void)sendMessage {
    NSDictionary *params = @{@"target_user_id" : self.shareUserId,
                             @"msg_type" : @(11),
                             @"report_img" : SafeString(self.qiniuKey),
                             @"consultation_record_id" : self.recordId
    };
    
    [GMNetworking requestOCWithApi:API_DOCTOR_SEND_REPORT_MESSAGE method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * _Nonnull response) {
        if (response.isSuccess) {
            [[GMBaseTool getCurrentViewController] toast:@"发送成功"];
        } else {
            [[GMBaseTool getCurrentViewController] toast:response.message];
        }
    }];
}

@end
