//
//  GMDiagnosisDispatchContainerViewController.m
//  Gengmei
//
//  Created by Jessica on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnosisDispatchContainerViewController.h"
#import "GMSegmentViewWithRedBadge.h"
#import "GMWaitingGrabListViewController.h"
#import "GMGrabedListViewController.h"
#import "GMDoctorConsultatioPromptView.h"
#import <GMBase/GMBaseTool.h>

@interface GMDiagnosisDispatchContainerViewController () <GMCustomNavigationAnimationProtocol>
@property (nonatomic, strong) GMSegmentViewWithRedBadge *segment;
@property (nonatomic, strong) GMDoctorConsultatioPromptView *promptView;

@end

@implementation GMDiagnosisDispatchContainerViewController
@synthesize navigationAnimation;

- (void)initController {
    [super initController];
    self.controlNavigationByYou = YES;
    // 自定义 push 动画
    self.navigationAnimation = [GMPresentAnimation new];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.navigationBar.isShowShadow = NO;
    self.title = @"面诊派单";
    self.navigationBar.rightIcon = @"wt_cancel_icon";
    self.navigationBar.leftIcon = @"wt_tip_black";
    [self.navigationBar addBottomLine];
    _segment = [[GMSegmentViewWithRedBadge alloc] init];
    _segment.bottomLine.hidden = YES;
    _segment.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, 40);
    [_segment addNavigationShadow];
    _segment.sectionTitles = @[@"待抢列表", @"已抢列表"];
    __weak typeof(self)weakSelf = self;
    _segment.didSelectedBlock = ^(NSUInteger index){
        [weakSelf switchToChildControllerAtIndex:index];
    };
    [_segment layoutSegments];
    
    [self.view addSubview:self.childContainer];
    self.childContainerSize = CGSizeMake(MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - OCNavigationBar.barHeight - _segment.height);
    self.childScrollViewDidEndScroll = ^(NSInteger index) {
        [weakSelf.segment setSelectedSegmentIndex:index animated:YES];
    };
    [self.view insertSubview:_segment aboveSubview:self.childContainer];
    [_segment mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.mas_equalTo(OCNavigationBar.barHeight);
        make.height.mas_equalTo(40);
    }];
    [self.childContainer mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(_segment.mas_bottom);
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(0);
        make.bottom.mas_equalTo(0);
    }];
    
    GMWaitingGrabListViewController *waitingGrab = [[GMWaitingGrabListViewController alloc] init];
    GMGrabedListViewController *grabedList = [[GMGrabedListViewController alloc] init];
    [self setFirstController:waitingGrab otherController:@[grabedList]];
    
    if (_segmentIndex > 0) {
        [self.segment setSelectedSegmentIndex:_segmentIndex animated:YES];
        [self switchToChildControllerAtIndex:_segmentIndex];
    }
}

// 点击问号，弹弹窗
- (void)backAction:(OCNavigationBarButton *)button {
    [self.view addSubview:self.promptView];
}

- (void)rightButtonClicked:(OCNavigationBarButton *)button {
    [[GMBaseTool getCurrentViewController].navigationController popViewControllerAnimated:YES];
}


- (GMDoctorConsultatioPromptView *)promptView {
    if (!_promptView) {
        _promptView = [[GMDoctorConsultatioPromptView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    }
    return _promptView;
}
@end
