//
//  GMDiagnosisWorkingTableViewModel.m
//  Gengmei
//
//  Created by Jessica on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnosisWorkingTableViewModel.h"
#import "RequestHeader.h"
@import GMNetworking;
@import GMFoundation;
@implementation GMDiagnosisWorkingTableViewModel
- (void)startConsultationWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock  {
  //构造参数
    NSMutableDictionary *parametes = [NSMutableDictionary dictionary];
    if (self.workTableObject.counsellorType != 2) {
        if (_tagIds.count > 0) {
            parametes[@"good_at"] = [NSString convertToPrettyPrintedJsonString:_tagIds];
        }
    }

    [GMNetworking requestOCWithApi:API_CONSULTATION_COUNSEL_START_CONSULTATION method:GMHTTPMethodPost parameters:parametes completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            successBlock(responseObject);
        } else {
            failBlock(responseObject.message);
        }
    }];
}

- (void)stopConsultationWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    [GMNetworking requestOCWithApi:API_CONSULTATION_COUNSEL_STOP_CONSULTATION method:GMHTTPMethodPost parameters:nil completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            successBlock(responseObject);
        } else {
            failBlock(responseObject.message);
        }
    }];
}

- (void)getAllTagsWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    [GMNetworking requestOCWithApi:API_CONSULTATION_COUNSEL_START_INFO method:GMHTTPMethodGet parameters:nil completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            successBlock(responseObject);
        } else {
            failBlock(responseObject.message);
        }
    }];
}

- (void)fetchWorkBenchHomeData:(void(^)(APIStatusCode, NSString *))block {
    __weak typeof(self) weakSelf = self;
    
    [GMNetworking requestOCWithApi:API_CONSULTATION_COUNSEL_WORKBENCH_HOME method:GMHTTPMethodGet parameters:nil completion:^(GMResponseOC *response) {
        [weakSelf converseHomeResponse:response];
        if (block != nil) {
            APIStatusCode status = [weakSelf homeApiStatus:response];
            block(status, response.message);
        }
    }];
}

- (APIStatusCode)homeApiStatus:(GMResponseOC *)response {
    if (self.dataArray.count > 0) {
        return APIStatusCodeSuccess;
    }
    if (response.isSuccess == NO) {
        return APIStatusCodeFailed;
    }else {
        return APIStatusCodeEmpty;
    }
}

- (void)converseHomeResponse:(GMResponseOC *)response {
    if (response.isSuccess) {
        NSDictionary *data = (NSDictionary *)(response.data);
        if (data == nil) {
            self.message = response.message;
        }else {
            [self buildModelWithListData:data];
        }
    } else {
    }
}

- (void)buildModelWithListData:(NSDictionary *)data {
    _workTableObject = [[GMWorkTableObject alloc] initWithDictionary:data error:nil];
    self.dataArray = [GMWorkTableNotifyObject arrayOfModelsFromDictionaries:data[@"notifies"] error:nil];
}

@end
