//
//  GMEditQuesPartViewModel.m
//  Gengmei
//
//  Created by Locus on 2020/2/19.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMEditQuesPartViewModel.h"
#import "GMBusinessReportListController.h"
#import <GMBase/GMBaseTool.h>
//#import "WMBrowserViewController.h"
#import "RequestHeader.h"
@import GMHud;
@import GMRouter;
@import GMFoundation;
@import GMNetworking;
@implementation GMEditQuesPartViewModel

- (instancetype)init {
    if (self = [super init]) {
        self.selectListModel = [GMEditQuesPartModel new];
    }
    return self;
}

- (void)requestSelectListDataWithType:(GMEditQuesPartType)type finishBlock:(nullable void (^)(NSArray<GMEditQuesPartDetailModel> * _Nonnull))finishBlock {
    NSMutableDictionary *params = [NSMutableDictionary new];
    NSString *api;
    if (type == GMEditQuesPartTypeSectionTag) {
        api = API_REPORT_SELECT_QUESTION_LIST;
    } else if (type == GMEditQuesPartTypeImproveAppeal) {
        api = API_REPORT_SELECT_APPEALS_LIST;
        [params setValue:@(self.editModel.sectionTag.id) forKey:@"section_tag"];
    } else {
        api = API_REPORT_SELECT_PROJECTS_LIST;
        [params setValue:self.editModel.improveAppealIdsStr forKey:@"improve_appeals"];
    }
    [GMNetworking requestOCWithApi:api method:GMHTTPMethodGet parameters:params completion:^(GMResponseOC * _Nonnull response) {
        if (response.isSuccess) {
            NSDictionary *data = response.data;
            NSArray<GMEditQuesPartDetailModel> *list;
            if (type == GMEditQuesPartTypeSectionTag) {
                list = (NSArray<GMEditQuesPartDetailModel> *)[GMEditQuesPartDetailModel arrayOfModelsFromDictionaries:data[@"section_tags"] error:nil];
                self.selectListModel.sectionTags = list;
            } else if (type == GMEditQuesPartTypeImproveAppeal) {
                list = (NSArray<GMEditQuesPartDetailModel> *)[GMEditQuesPartDetailModel arrayOfModelsFromDictionaries:data[@"improve_appeals"] error:nil];
                self.selectListModel.improveAppeals = list;
            } else {
                list = (NSArray<GMEditQuesPartDetailModel> *)[GMEditQuesPartDetailModel arrayOfModelsFromDictionaries:data[@"suit_projects"] error:nil];
                self.selectListModel.suitProjects = list;
            }
            if (finishBlock) {
                finishBlock(list);
            }
        }
    }];
    
}

- (void)saveQuesPart {
    if (!self.editModel.sectionTag) {
        [[GMBaseTool getCurrentViewController] toast:@"请先选择问题部位"];
    } else if (self.editModel.improveAppeals.count == 0) {
        [[GMBaseTool getCurrentViewController] toast:@"请先选择改善诉求"];
    } else if (self.editModel.suitProjects.count == 0) {
           [[GMBaseTool getCurrentViewController] toast:@"请先选择适应项目"];
    } else {
        NSString *api = [self.editModel.reportitemId isNonEmpty] ? API_QUESTION_PART_EDIT : API_QUESTION_PART_ADD;
        NSMutableDictionary *params = [NSMutableDictionary new];
        [params setValue:self.recordId forKey:@"record_id"];
        [params setValue:self.editModel.reportitemId forKey:@"reportitem_id"];
        [params setValue:@(self.editModel.sectionTag.id) forKey:@"section_tag"];
        [params setValue:self.editModel.improveAppealIdsStr forKey:@"improve_appeals"];
        [params setValue:self.editModel.suitProjectIdsStr forKey:@"suit_projects"];
        [params setValue:self.editModel.otherSuggestions forKey:@"other_suggestions"];
        UIViewController *currentVC = [GMBaseTool getCurrentViewController];

        [GMNetworking requestOCWithApi:api method:GMHTTPMethodPost parameters:params completion:^(GMResponseOC * _Nonnull response) {
            if (response.isSuccess) {
                [self editQuesPartFinish];
                if ([self isFromReportDetail]) {
                    [currentVC popViewControllerAnimated:YES completion:^{
                        [currentVC toast:[self.editModel.reportitemId isNonEmpty] ? @"保存成功" : @"添加成功"];
                    }];
                } else {
                    [currentVC popViewControllerAnimated:NO completion:nil];
                    [[GMRouter sharedInstance] pushScheme:response.data[@"gm_url"]];
                }
            } else {
                [currentVC toast:response.message];
            }
        }];
    }
}

- (void)deleteQuesPart {
    UIViewController *currentVC = [GMBaseTool getCurrentViewController];

    [GMNetworking requestOCWithApi:API_QUESTION_PART_DELETE method:GMHTTPMethodPost parameters:@{@"reportitem_id" : SafeString(self.editModel.reportitemId)} completion:^(GMResponseOC * _Nonnull response) {
        if (response.isSuccess) {
            [self editQuesPartFinish];
            [currentVC popViewControllerAnimated:YES completion:^{
                [currentVC toast:@"删除成功"];
            }];
        } else {
            [currentVC toast:response.message];
        }
    }];
}

//TODO: 待测试
- (BOOL)isFromReportDetail {
    BOOL isDetail = [[[GMRouter sharedInstance] pushScheme:@"gengmei://gm_isFromReportDetail"]  boolValue];
    return isDetail;
}

- (void)editQuesPartFinish {
    [[GMRouter sharedInstance] pushScheme:@"gengmei://gm_editQuesPartFinish"];
//    NSArray<__kindof UIViewController *> *viewControllers = [GMBaseTool getCurrentViewController].navigationController.viewControllers;
//    if (viewControllers.count > 1) {
//        UIViewController *preVC = viewControllers[viewControllers.count - 2];
//        if ([preVC isKindOfClass:[GMBusinessReportListController class]]) {
//            [[NSNotificationCenter defaultCenter] postNotificationName:GM_WORKING_EDIT_QUESTION_PART_NOTIFICATION object:nil];
//        } else if ([preVC isKindOfClass:[WMBrowserViewController class]]) {
//            [((WMBrowserViewController *)preVC) reloadURL];
//        }
//    }
}

@end
