//
//  GMWaitingGrabViewModel.m
//  Gengmei
//
//  Created by Jessica on 2020/3/6.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMWaitingGrabViewModel.h"
@import GMNetworking;
@implementation GMWaitingGrabViewModel
- (void)handleHeaderRefreshing {
    
}

- (void)grabOrderWithTaskId:(NSString *)taskId successBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    //构造参数
    NSMutableDictionary *parametes = [NSMutableDictionary dictionary];
    parametes[@"dispatch_task_id"] = SafeString(taskId);

    [GMNetworking requestOCWithApi:@"/api/consultation_counsel/workbench/join_dispatch" method:GMHTTPMethodPost parameters:parametes completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            successBlock(responseObject);
        } else {
            failBlock(responseObject.message);
        }
    }];
}

- (void)fetchWaitingListData:(void(^)(APIStatusCode, NSString *))block {
    if (self.dataArray.count > 0) {
        [self.dataArray removeAllObjects];
    }
    __weak typeof(self) weakSelf = self;
    [GMNetworking requestOCWithApi:@"/api/consultation_counsel/workbench/current_dispatch_task_list" method:GMHTTPMethodGet parameters:nil completion:^(GMResponseOC *response) {
        [weakSelf converseListResponse:response];
        if (block != nil) {
            APIStatusCode status = [weakSelf homeApiStatus:response];
            block(status, response.message);
        }
    }];
}

- (APIStatusCode)homeApiStatus:(GMResponseOC *)response {
    if (self.dataArray.count > 0) {
        return APIStatusCodeSuccess;
    }
    if (response.isSuccess == NO) {
        return APIStatusCodeFailed;
    }else {
        return APIStatusCodeEmpty;
    }
}

- (void)converseListResponse:(GMResponseOC *)response {
    if (response.isSuccess) {
        NSArray *data = (NSArray *)(response.data);
        if (data == nil) {
            self.message = response.message;
        }else {
            [self buildModelWithListData:data];
        }
    } else {
    }
}

- (void)buildModelWithListData:(NSArray *)data {
    NSArray *tempArray = [GMDispatchWaitingGrabObject arrayOfModelsFromDictionaries:data error:nil];
    [self.dataArray addObjectsFromArray:tempArray];
}
@end
