//
//  GMDiagnoseRecordWebViewController.m
//  Gengmei
//
//  Created by yefengming on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMDiagnoseRecordWebViewController.h"
//#import "Gengmei-Swift.h"
#import "GMEndConsultView.h"
#import "GMComplaintObject.h"
#import "GMComplaintResultView.h"
#import "GMSureOrderPopView.h"
#import "GMToFaceOrderInfoModel.h"
#import "GMToFaceNetworking.h"
#import "NSString+AIJsonData.h"
#import <GMBase/GMBase-Swift.h>
#import "RequestHeader.h"
#import <GMBaseWeb/GMBaseWeb-Swift.h>

@import GMBase;
@import WebKit.WKWebView;
@interface GMViewEvaluateModel: GMObject
//面诊id
@property (nonatomic, copy) NSString *consultationId;
@property (nonatomic, assign) NSInteger star;
@property (nonatomic, copy) NSString *desc;
//是否展示去投诉字段
@property (nonatomic, assign) BOOL showComplaint;
//页面名称
@property (nonatomic, copy) NSString *tabName;
@end
@implementation GMViewEvaluateModel @end

@interface GMDiagnoseRecordWebViewController () <WKWebViewDelegate>
@property (nonatomic, strong) GMComplaintObject *complaintObject;

@property (nonatomic, assign) BOOL isSureOrder;
@end

@implementation GMDiagnoseRecordWebViewController

-(void)initController {
    [super initController];
    self.path = API_USER_RECORD_LIST_V4;
    //TODO: 待测试
    NSInteger userId = (NSInteger)[[GMRouter sharedInstance] pushScheme:@"gengmei://gm_userId"];
    self.businessId = [NSString stringWithFormat:@"%ld", userId];
    self.pageName = @"video_face_consultation_order_record";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
}

- (void)backAction:(OCNavigationBarButton *)button {
    [super backAction:button];
    [Phobos track:@"on_click_button" attributes:@{@"button_name":@"exit",
                                                  @"page_name":self.pageName,
                                                  @"referrer_link":(self.referrerLink ? : @[])
    }];
}
#pragma mark - 查看评价和去评价
- (void)viewEvaluate:(NSString *)jsonString {
    NSDictionary *jsonDict = [jsonString dictionaryWithJsonString];
    GMViewEvaluateModel *model = [[GMViewEvaluateModel alloc] initWithDictionary:jsonDict error:nil];
    //有星星就是查看评价，没有星星就是去评价
    GMEndConsultViewType type = model.star == 0 ? GMEndConsultViewTypeGrayStar : GMEndConsultViewTypeViewEvaluate;
    //查看评价
    if (type == GMEndConsultViewTypeViewEvaluate) {
        GMEndConsultView *consultView = [[GMEndConsultView alloc] initWithType:type starNum:model.star];
        consultView.clickComplaintButtonBlock = ^{
            [Phobos track:@"on_click_button" attributes:@{@"page_name":@"video_interview_record",
                                                          @"button_name":@"complaint",
                                                          @"tab_name":SafeString(model.tabName),
                                                          @"referrer_link":self.referrerLink}];
        };
        consultView.desc = model.desc;
        consultView.showComplaint = model.showComplaint;
        consultView.recordId = model.consultationId;
        [[GMBaseTool mainWindow]  addSubview:consultView];
    }else {
        [GMHudModule showLoading:nil];
        //获取每个星级对应的评价
        __weak typeof(self) weakSelf = self;
        [[GMToFaceNetworking shareInstance] excuteToFaceEvaluateItemDiagnosis_id:model.consultationId SuccessBlock:^(id response) {
            [GMHudModule hideLoading];
            GMStarWithContentObject *starContentModel = [[GMStarWithContentObject alloc] initWithDictionary:response error:nil];
            GMEndConsultView *view = [[GMEndConsultView alloc] initWithType:type starNum:0];
            view.clickComplaintButtonBlock = ^{
                [Phobos track:@"on_click_button" attributes:@{@"page_name":@"video_interview_record",
                                                              @"button_name":@"complaint",
                                                              @"tab_name":SafeString(model.tabName),
                                                              @"referrer_link":self.referrerLink}];
            };
            //评价后回传给H5的方法
            view.evaluateFinish = ^(NSInteger type, NSInteger starNum, NSString * _Nonnull evaluateStr) {
                NSDictionary *dict = @{@"type":@(type),@"star":@(starNum),@"desc":evaluateStr};
                if (type == 1) {
                    dict = @{@"type":@(type)};
                }
                NSString *str = [NSDictionary dictionaryToJson:dict];
                NSString *jsStr = [NSString stringWithFormat:@"window.gm&&window.gm.pack&&window.gm.pack.run('evaluateCallback',%@)", str];
                [weakSelf.webCompent.webView evaluateJavaScript:jsStr completionHandler:nil];
            };
            view.showComplaint = model.showComplaint;
            view.recordId = model.consultationId;
            view.starContentArray = starContentModel.evaluates;
            [[GMBaseTool mainWindow]  addSubview:view];
        } failureBlock:^(NSInteger errorCode, NSString *message) {
            [GMHudModule hideLoading];
            [[GMBaseTool getCurrentViewController] toast:@"获取评价内容失败"];
        }];
    }
}
#pragma mark - 查看投诉
- (void)viewComplaint:(NSString *)jsonString {
    NSString *diagonosisId = SafeString(jsonString);
    [GMHudModule showLoading:nil];
    __weak typeof(self) weakSelf = self;
    [[GMToFaceNetworking shareInstance] excuteToFaceComplaintGetDiagnosis_id:diagonosisId SuccessBlock:^(id response) {
        [GMHudModule hideLoading];
        GMComplaintInterfaceObject *model = [[GMComplaintInterfaceObject alloc] initWithDictionary:response error:nil];
        weakSelf.complaintObject.report_detail = model.complaint.content;
        weakSelf.complaintObject.report_time = model.complaint.time;
        weakSelf.complaintObject.deal_detail = model.reply.content;
        weakSelf.complaintObject.deal_time = model.reply.time;
        weakSelf.complaintObject.custom_url = model.custom_url;
        weakSelf.complaintObject.status = model.status;
        GMComplaintResultView *view = [[GMComplaintResultView alloc] initWithType:weakSelf.complaintObject.status dictModel:weakSelf.complaintObject];
        [[GMBaseTool mainWindow]  addSubview:view];
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        [GMHudModule hideLoading];
        [[GMBaseTool getCurrentViewController] toast:message];
    }];
}
#pragma mark - 面诊订单列表调起确认订单弹窗
- (void)viewConfirm:(NSString *)jsonString {
    if (self.isSureOrder) {
        return;
    }
    self.isSureOrder = YES;
    NSDictionary *jsonDict = [jsonString dictionaryWithJsonString];
    NSString *orderNo = jsonDict[@"order_no"];
    NSString *consultationRecordId = jsonDict[@"consultation_id"];
    //确认订单
    __weak typeof(self) weakSelf = self;
    [self showLoading:nil];
    [[GMToFaceNetworking shareInstance] excuteToFaceInfoSureOrder:SafeString(orderNo) SuccessBlock:^(id response) {
        [weakSelf hideLoading];
        weakSelf.isSureOrder = NO;
        GMToFaceOrderInfoModel *infoModel = [[GMToFaceOrderInfoModel alloc] initWithDictionary:response error:nil];
        infoModel.consultationRecordId = consultationRecordId;
        GMSureOrderPopView *popView = [[GMSureOrderPopView alloc] init];
        popView.isCloseBtnHidden = NO;
        [popView clickConfireBtnPhobo:infoModel.counsellorType consultationType:infoModel.recordType doctorId:SafeString(infoModel.counsellorId)];
        popView.completeCallBack = ^(NSInteger type, NSString *desc, NSInteger star) {
            NSDictionary *dict = @{@"type":@(type),@"star":@(star),@"desc":desc};
            NSString *str = [NSDictionary dictionaryToJson:dict];
            NSString *jsStr = [NSString stringWithFormat:@"window.gm&&window.gm.pack&&window.gm.pack.run('confirmCallback',%@)", str];
            [weakSelf.webCompent.webView evaluateJavaScript:jsStr completionHandler:nil];
        };
        popView.infoModel = infoModel;
        [[GMBaseTool mainWindow]  addSubview:popView];
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        weakSelf.isSureOrder = NO;
        [weakSelf hideLoading];
        [[GMBaseTool getCurrentViewController] toast:message];
    }];
}
- (GMComplaintObject *)complaintObject {
    if (!_complaintObject) {
        _complaintObject = [[GMComplaintObject alloc] init];
    }
    return _complaintObject;
}
@end
