//
//  GMPlayBackWelfareCell.m
//  Gengmei
//
//  Created by yefengming on 2020/2/22.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPlayBackWelfareCell.h"

@implementation GMPlayBackWelfareCell
{
    GMImageView *_iconImg;
    UILabel *_titleLabel;
    UILabel *_priceLabel;
    UILabel *_originalRriceLabel;
     
}

- (void)setup {
    [super setup];
    UIView *back = [[UIView alloc] init];
    [self addSubview:back];
    [back mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(112);
        make.edges.mas_equalTo(UIEdgeInsetsZero);
    }];
    
    _iconImg = [[GMImageView alloc] init];
    _iconImg.backgroundColor = UIColor.redColor;
    _iconImg.layer.masksToBounds = YES;
    _iconImg.layer.cornerRadius = 5.0;
    [back addSubview:_iconImg];
    [_iconImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(16);
        make.size.mas_equalTo(CGSizeMake(80, 80));
        make.centerY.mas_equalTo(0);
    }];
    
    _titleLabel = [[UILabel alloc] init];
    _titleLabel.font = [UIFont boldSystemFontOfSize:15];
    _titleLabel.numberOfLines = 2;
    _titleLabel.text = @"【菲洛嘉】菲洛嘉10ml足量改善肤质 含高值术后品质 任选6项目组合";
    _titleLabel.textColor = RGBCOLOR_HEX(0x464646);
    [back addSubview:_titleLabel];
    [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_iconImg.mas_right).offset(10);
        make.top.equalTo(_iconImg.mas_top).offset(3);
        make.right.equalTo(back.mas_right).offset(-16);
    }];
    
    _originalRriceLabel = [[UILabel alloc] init];
    _originalRriceLabel.font = [UIFont systemFontOfSize:14];
    _originalRriceLabel.textColor = RGBCOLOR_HEX(0xFF5963);
    _originalRriceLabel.text = @"¥";
    [back addSubview:_originalRriceLabel];
    [_originalRriceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_titleLabel.mas_left);
        make.bottom.equalTo(_iconImg.mas_bottom).offset(-3);
    }];
    
    _priceLabel= [[UILabel alloc] init];
    _priceLabel.font = [UIFont boldSystemFontOfSize:20];
    _priceLabel.textColor = RGBCOLOR_HEX(0xFF2F4F);
    _priceLabel.text = @"¥3899";
    [back addSubview:_priceLabel];
    [_priceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(_originalRriceLabel.mas_right).offset(1);
        make.centerY.mas_equalTo(_originalRriceLabel);
    }];
    
    GMButton *shoping = [[GMButton alloc] init];
    [shoping setImage:[UIImage imageNamed:@"play_back_shopping"] forState:UIControlStateNormal];
    [shoping setImage:[UIImage imageNamed:@"play_back_shopping"] forState:UIControlStateHighlighted];
    [back addSubview:shoping];
    [shoping mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(13, 13));
        make.right.equalTo(self.mas_right).offset(-16);
        make.bottom.equalTo(_iconImg.mas_bottom);
    }];
    [self updateBottomLineConstraintsWithLeft:16 right:-16];
}

- (void)setWelfareObject:(GMWelfareServiceObject *)welfareObject {
    _welfareObject = welfareObject;
    _titleLabel.text = welfareObject.serviceName;
    _priceLabel.text = welfareObject.gengmeiPrice;
    [_iconImg setImageWithUrlString:welfareObject.image placeHolder:nil];
}

@end
