//
//  GMVideoInfoView.m
//  Gengmei
//
//  Created by yefengming on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoInfoView.h"
#import "GMLibraryHeader.h"

@interface GMVideoInfoView ()
@property (nonatomic, strong) GMImageView *topView;
@property (nonatomic, strong) GMImageView *iconView;
@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *infoLabel;
@property (nonatomic, strong) GMButton *closeButton;
@property (nonatomic, strong) GMButton *clearBtn;
@end

@implementation GMVideoInfoView

- (void)setup {
    [super setup];
    self.backgroundColor = [UIColor clearColor];
    _topView = [[GMImageView alloc]init];
    _topView.contentMode = UIViewContentModeScaleAspectFill;
    [self addSubview:_topView];
    [_topView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.mas_equalTo(0);
    }];
    _topView.image = [UIImage imageNamed:@"play_back_top"];
    
    _iconView = [[GMImageView alloc]init];
    _iconView.clipsToBounds = YES;
    _iconView.layer.cornerRadius = 30;
    _iconView.contentMode = UIViewContentModeScaleAspectFill;
    [self addSubview:_iconView];
    [_iconView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_topView.mas_bottom).offset(32);
        make.left.mas_equalTo(20);
        make.size.mas_equalTo(CGSizeMake(60, 60));
    }];
    
    _nameLabel = [GMLabel labelWithTextAlignment:NSTextAlignmentLeft backgroundColor:[UIColor clearColor] textColor:UIColor.whiteColor fontSize:16];
    _nameLabel.font = [UIFont gmBoldFont:16];
    [self addSubview:_nameLabel];
    [_nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_iconView).offset(8);
        make.left.mas_equalTo(_iconView.mas_right).offset(12);
    }];
    
    _infoLabel = [GMLabel labelWithTextAlignment:NSTextAlignmentLeft backgroundColor:[UIColor clearColor] textColor:RGBCOLOR_HEX(0xC3C2C4) fontSize:12];
    [self addSubview:_infoLabel];
    [_infoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(_iconView).offset(-8);
        make.left.mas_equalTo(_iconView.mas_right).offset(12);
        make.right.mas_equalTo(-12);
    }];
    
    _closeButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [_closeButton setImage:[UIImage imageNamed:@"play_back_close"] forState:UIControlStateNormal];
    [self addSubview:_closeButton];
    [_closeButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-18);
        make.centerY.mas_equalTo(_topView);
    }];
    
    self.clearBtn = [GMButton buttonWithType:UIButtonTypeCustom];
    [self.clearBtn addTarget:self action:@selector(closeLiveAction) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:self.clearBtn];
    [self.clearBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-18);
        make.centerY.mas_equalTo(_topView);
        make.size.mas_equalTo(CGSizeMake(40, 40));
    }];
}

- (void)setPlayBackObject:(GMVideoPlayBackObject *)playBackObject {
    _playBackObject = playBackObject;
    [_iconView setImageWithUrlString:playBackObject.consultationCounsellerInfo.portrait placeHolder:nil];
    _nameLabel.text = playBackObject.consultationCounsellerInfo.name;
    if (playBackObject.consultationRecordInfo.userTargetProjectName.isNonEmpty) {
        _infoLabel.text = [NSString stringWithFormat:@"面诊项目 | %@",playBackObject.consultationRecordInfo.userTargetProjectName];
    }
}

- (void)closeLiveAction{
    if ([self.delegate respondsToSelector:@selector(videoInfoView:didClickCloseButton:)]) {
        [self.delegate videoInfoView:self didClickCloseButton:_clearBtn];
    }
}

@end
