//
//  GMVideoPlayBackViewModel.m
//  Gengmei
//
//  Created by yefengming on 2020/2/21.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMVideoPlayBackViewModel.h"
#import "RequestHeader.h"
@import GMNetworking;

@implementation GMVideoPlayBackViewModel

- (void)fetchPlayBackWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    [GMNetworking requestOCWithApi:API_CONSULTATION_COUNSELLER_REPLAY_INFO method:GMHTTPMethodGet parameters:@{@"consultation_record_id":SafeString(self.consultationRecordId)} completion:^(GMResponseOC * _Nonnull response) {
        if (response.data) {
            successBlock(response.data);
        }
    }];
}

- (void)fetchPlayBackRecommendWithSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock {
    [GMNetworking requestOCWithApi:API_CONSULTATION_GET_RECOMMENDED_BAG method:GMHTTPMethodGet parameters:@{@"record_id":SafeString(self.consultationRecordId)} completion:^(GMResponseOC * _Nonnull response) {
        if (response.data) {
            successBlock(response.data);
        }
    }];
}

@end
