//
//  GMAIUploadImagesManager.h
//  Gengmei
//
//  Created by 卢悦明 on 2020/5/14.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GMbase/GMObject.h>
typedef NS_ENUM(NSUInteger, GMAITokenType) {
    GMAITokenTypeImage = 1,// 图片
    GMAITokenTypeViedo,// 视频
};

/** @brief 返回结果Block */
typedef void(^UploadFinishedBlock)(BOOL result, NSString *message);
@interface GMAIUploadImagesManager : GMObject

+ (instancetype)shareInstance;

@property (nonatomic, strong) NSMutableArray *resultImages;

- (NSString *)createImagePath;

//  1： '图片' 2：'视频'
- (void)getTokenWithType:(GMAITokenType)type resultBlock:(UploadFinishedBlock)resultBlock;

-(void)uploadImages:(NSArray *)images imageToken:(NSString *)imageToken resultBlock:(UploadFinishedBlock)resultBlock;


/// 返回{"width": 200, "type": "image", "image_url": "", "height": 400} 这样的一个字典，
/// 用于上传给服务器
+ (nonnull NSDictionary *)imageInfoWithPath:(NSString *_Nullable)path width:(NSInteger)width height:(NSInteger)height;
@end

