//
//  GMInterfaceNetwork.m
//  Gengmei
//
//  Created by MoMo on 2019/8/14.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceNetworking.h"
#import "RequestHeader.h"
#import <GMKit/GMSafeValue.h>

@implementation GMToFaceNetworking

static GMToFaceNetworking *_instance;

+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _instance = [[GMToFaceNetworking alloc] init];
    });
    return _instance;
}

/**
 * 视频面诊 打星评价项获取
 * iagnosis_id   面诊 ID
 */
- (NSURLSessionTask *)excuteToFaceEvaluateItemDiagnosis_id:(NSString *)diagnosis_id
                                              SuccessBlock:(GMSuccessBlock)successBlock
                                              failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"diagnosis_id":diagnosis_id};
    return [self sendRequstWithApi:API_CONSULTATION_COUNSEL_EVALUATE_ITEM method:GMHTTPMethodGet parameters:dict successBlock:successBlock failureBlock:failureBlock];
}

/**
 * 视频面诊 获取投诉意见
 * diagnosis_id   面诊 ID
 */
- (NSURLSessionTask *)excuteToFaceComplaintGetDiagnosis_id:(NSString *)diagnosis_id
                                              SuccessBlock:(GMSuccessBlock)successBlock
                                              failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"diagnosis_id":diagnosis_id};
    return [self sendRequstWithApi:API_CONSULTATION_COUNSEL_COMPLAINT method:GMHTTPMethodGet parameters:dict successBlock:successBlock failureBlock:failureBlock];
}
/**
 * 视频面诊订单信息确认
 * order_no : 订单编号
 */
- (NSURLSessionTask *)excuteToFaceInfoSureOrder:(NSString *)order_no
                                   SuccessBlock:(GMSuccessBlock)successBlock
                                   failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"order_no":SafeString(order_no)};
    return [self sendRequstWithApi:API_ORDER_INFO method:GMHTTPMethodGet parameters:dict successBlock:successBlock failureBlock:failureBlock];
}


/**
 * 查看封禁信息
 */
- (NSURLSessionTask *)excuteToFaceBlockInfoSuccessBlock:(GMSuccessBlock)successBlock
                                           failureBlock:(GMFailureBlock)failureBlock {
    return [self sendRequstWithApi:API_CONSULTATION_COUNSEL_BLOCK_INFO method:GMHTTPMethodGet parameters:nil successBlock:successBlock failureBlock:failureBlock];
}
/// 视频面诊频道推荐医生
- (NSURLSessionTask *)excuteToFaceRecommendDoctorsSuccessBlock:(GMSuccessBlock)successBlock
                                                  failureBlock:(GMFailureBlock)failureBlock {
    return [self sendRequstWithApi:API_CONSULTATION__COUNSEL_DOCTORS method:GMHTTPMethodGet parameters:nil successBlock:successBlock failureBlock:failureBlock];
}
/// 视频面诊频道tab 医生列表
- (NSURLSessionTask *)excuteToFaceTabsDoctorsTabsId:(NSInteger)tabsId
                                               page:(NSInteger)page
                                       SuccessBlock:(GMSuccessBlock)successBlock
                                       failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"tab_id":@(tabsId),@"page":@(page)};
    return [self sendRequstWithApi:API_CONSULTATION__COUNSEL_TABS_DOCTORS method:GMHTTPMethodGet parameters:dict successBlock:successBlock failureBlock:failureBlock];
}
/**
 * 视频面诊订单确认
 * order_no : 订单编号
 */
- (NSURLSessionTask *)excuteToFaceSureOrder:(NSString *)order_no
                               SuccessBlock:(GMSuccessBlock)successBlock
                               failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"order_no":SafeString(order_no)};
    return [self sendRequstWithApi:API_ORDER_CHECK method:GMHTTPMethodPost parameters:dict successBlock:successBlock failureBlock:failureBlock];
}



#pragma mark - custum Requst
- (NSURLSessionTask *)sendRequstWithApi:(NSString *)uri method:(GMHTTPMethod)method parameters:(NSDictionary *)params successBlock:(GMSuccessBlock)successBlock failureBlock:(GMFailureBlock)failureBlock {
    
    return [self sendRequstWithApi:uri method:method parameters:params cachePolicy:GMCachePolicyNone loadingType:GMLoadingTypeNone successBlock:successBlock failureBlock:failureBlock];
}

- (NSURLSessionTask *)sendRequstWithApi:(NSString *)uri method:(GMHTTPMethod)method parameters:(NSDictionary *)params cachePolicy:(GMCachePolicy)cachePolicy loadingType:(GMLoadingType)loadingType successBlock:(GMSuccessBlock)successBlock failureBlock:(GMFailureBlock)failureBlock {
    
    NSMutableURLRequest *requst = (NSMutableURLRequest *)[GMNetworking customRequestWithApi:uri method:method parameters:params];
    requst.timeoutInterval = 30.0f;
    NSURLSessionTask *dataTask = nil;
    dataTask = [GMNetworking sendOCBack:requst completion:^(GMResponseOC *response) {
        if (response.isSuccess) {
            if (successBlock) {
                successBlock(response.data);
            }
        } else {
            if (failureBlock) {
                failureBlock(response.errorCode,response.message);
            }
        }
    }];
    return dataTask;
}



/**
 * 视频面诊 打星评价
 * iagnosis_id   面诊 ID
 * star          星星数
 */
- (NSURLSessionTask *)excuteToFaceEvaluateDiagnosis_id:(NSString *)diagnosis_id
                                                  star:(NSInteger )star
                                          SuccessBlock:(GMSuccessBlock)successBlock
                                          failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"diagnosis_id":diagnosis_id, @"star":@(star)};
    return [self sendRequstWithApi:API_CONSULTATION_COUNSEL_EVALUATE method:GMHTTPMethodPost parameters:dict successBlock:successBlock failureBlock:failureBlock];
}
/**
 * 视频面诊 是否是医生本人
 * is_doctor      0不是医生本人 1 医生本人
 * diagnosis_id   面诊 ID
 */
- (NSURLSessionTask *)excuteToFaceIsSureDoctor:(NSInteger )is_doctor
                                  diagnosis_id:(NSString *)diagnosis_id
                                  SuccessBlock:(GMSuccessBlock)successBlock
                                  failureBlock:(GMFailureBlock)failureBlock {
    NSDictionary *dict = @{@"is_doctor":@(is_doctor),@"diagnosis_id":diagnosis_id};
    return [self sendRequstWithApi:API_CONSULTATION_COUNSEL_IDENTITY method:GMHTTPMethodPost parameters:dict successBlock:successBlock failureBlock:failureBlock];
}


@end
