//
//  GMAIChannelViewController.m
//  GMAILab
//
//  Created by cfy on 2020/4/29.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMAIChannelViewController.h"
#import "GMVerticalFlowLayout.h"
#import "GMAIChannelViewModel.h"
#import "GMAICardCollectionCell.h"
#import "NSBundle+GMAILab.h"

@import Masonry;
@import GMKit;

@interface GMAIChannelViewController () <UICollectionViewDelegate, UICollectionViewDataSource, GMVerticalFlowLayoutDelegate>

@property(nonatomic, strong) UICollectionView *collectionView;
@property(nonatomic, strong) GMVerticalFlowLayout *collectionLayout;
@property(nonatomic, strong) GMAIChannelViewModel *viewModel;

@end

@implementation GMAIChannelViewController

#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    [self.view addSubview:self.collectionView];
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
}

#pragma mark - UICollectionViewDelegate & UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 10;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    GMAICardCollectionCell *cell = [collectionView dequeueCell:GMAICardCollectionCell.class forIndexPath:indexPath];    
    return cell;
}

#pragma mark - GMVerticalFlowLayoutDelegate
- (NSInteger)waterflowLayout:(GMVerticalFlowLayout *)waterflowLayout columnsInCollectionView:(UICollectionView *)collectionView {
    return 2;
}

- (CGFloat)waterflowLayout:(GMVerticalFlowLayout *)waterflowLayout collectionView:(UICollectionView *)collectionView heightForItemAtIndexPath:(NSIndexPath *)indexPath itemWidth:(CGFloat)itemWidth {
    
    return 350;
}

- (UIEdgeInsets)waterflowLayout:(GMVerticalFlowLayout *)waterflowLayout edgeInsetsInCollectionView:(UICollectionView *)collectionView {
    return UIEdgeInsetsMake(8, 8, 8, 8);
}

- (CGFloat)waterflowLayout:(GMVerticalFlowLayout *)waterflowLayout collectionView:(UICollectionView *)collectionView linesMarginForItemAtIndexPath:(NSIndexPath *)indexPath {
    return 9;
}

#pragma mark - event response


#pragma mark - setter & getter
- (UICollectionView *)collectionView {
    if (!_collectionView) {
        _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:self.collectionLayout];
        _collectionView.backgroundColor = [UIColor colorWithHexString:@"F7F6FA"];
        _collectionView.dataSource = self;
        _collectionView.delegate = self;
        [_collectionView registerCell:GMAICardCollectionCell.class];
        
        NSBundle *bundle = [NSBundle gm_AILabBundle:GMAICardCollectionCell.class];
        UINib *nib = [UINib nibWithNibName:NSStringFromClass(GMAICardCollectionCell.class) bundle:bundle];
        [_collectionView registerNib:nib forCellWithReuseIdentifier:NSStringFromClass(GMAICardCollectionCell.class)];
    }
    return _collectionView;
}

- (GMVerticalFlowLayout *)collectionLayout {
    if (!_collectionLayout) {
        _collectionLayout = [GMVerticalFlowLayout flowLayoutWithDelegate:self];
    }
    return _collectionLayout;
}

- (GMAIChannelViewModel *)viewModel {
    if (!_viewModel) {
        _viewModel = [GMAIChannelViewModel new];
    }
    return _viewModel;
}

@end
