//
//  GMToFaceDoctorListModel.h
//  Gengmei
//
//  Created by zhouLiang on 2020/2/20.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//
@import GMBase;

@protocol GMToFaceTabs @end
@interface GMToFaceTabs : GMObject
@property (nonatomic, assign) NSInteger id;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, assign) BOOL selected;
@end

@protocol GMToFaceRecommendsDoctors @end
@interface GMToFaceRecommendsDoctors : GMObject
@property (nonatomic, copy) NSString *counsellorId;
@property (nonatomic, copy) NSString *doctorId;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *cityName;
@property (nonatomic, copy) NSString *portrait;
// 形象照
@property (nonatomic, copy) NSString *personalPicture;
@property (nonatomic, copy) NSString *userId;
/** 1(不在线)/2(在线)/3(视频面诊中) */
@property (nonatomic, assign) NSInteger status;
/** 0/1 是否是助理 */
@property (nonatomic, assign) NSInteger isAssistant;
/** 医生职称 */
@property (nonatomic, copy) NSString *title;
/** 执业时间 */
@property (nonatomic, copy) NSString *practisingTime;
/** 擅长项目 */
@property (nonatomic, copy) NSString *goodAt;
/** 是否关注 */
@property (nonatomic, assign) BOOL isFollow;
/** 医生主页协议 */
@property (nonatomic, copy) NSString *gm_url;
/** 面诊顾问类型, 1: 医生, 2:面诊师 */
@property (nonatomic, assign) NSInteger type;

/** 好评率 */
@property (nonatomic, copy) NSString *likeRate;
/** 接通率 */
@property (nonatomic, copy) NSString *connectRate;
/** 有效面诊人数 */
@property (nonatomic, copy) NSString *consultPeopleNumber;
/** 展示类型,0：不显示 1: 好评率 + 接通率 2: 好评率 + 有效面诊人数*/
@property (nonatomic, assign) NSInteger showType;
/** 面诊价格 */
@property (nonatomic, assign) NSInteger serviceFee;
/** 面诊价格 */
@property (nonatomic, copy) NSString *serviceFeeStr;
@property (nonatomic, strong) NSDictionary *exposure;
@end

@interface GMToFaceTabsDoctorListModel : GMObject
/** 推荐医生列表 */
@property (nonatomic, strong) NSMutableArray <GMToFaceRecommendsDoctors>*counsellors;

@end

@interface GMToFaceDoctorListModel : GMObject
/** 推荐医生列表 */
@property (nonatomic, strong) NSMutableArray <GMToFaceRecommendsDoctors>*recommendsCounsellors;
/** tab */
@property (nonatomic, strong) NSMutableArray <GMToFaceTabs>*tabs;
/** 没有被封禁则为空对象 */
@property (nonatomic, copy) NSString *blockInfo;

@end
