//
//  GMToFaceCommonEmptyView.m
//  GMAILab
//
//  Created by 卢悦明 on 2020/5/9.
//

#import "GMToFaceCommonEmptyView.h"

@interface GMToFaceCommonEmptyView ()
@property (nonatomic, strong) GMButton *tapBtn;

@end

@implementation GMToFaceCommonEmptyView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    self.backgroundColor = UIColor.whiteColor;

    _emptyImg = [GMImageView new];
    _emptyImg.contentMode = UIViewContentModeScaleAspectFit;
    _emptyImg.image = [UIImage imageNamed:@"empty"];
    [self addSubview:_emptyImg];
    [_emptyImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.centerY.mas_equalTo(-20);
        make.size.mas_equalTo(CGSizeMake(175, 199));
    }];
    // 349/396
    _emptyLabel = [GMLabel labelWithTextColor:UIColor.bodyText fontSize:15];
    _emptyLabel.preferredMaxLayoutWidth = 300;
    _emptyLabel.textAlignment = NSTextAlignmentCenter;
    _emptyLabel.text = @"此处太寂寥，社区等你撩";
    _emptyLabel.numberOfLines = 0;
    [self addSubview:_emptyLabel];
    [_emptyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(_emptyImg.mas_bottom).offset(-30);
        make.centerX.mas_equalTo(0);
    }];
    [self addSubview:self.tapBtn];
    [self.tapBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.width.mas_equalTo(150);
        make.height.mas_equalTo(33);
        make.top.mas_equalTo(_emptyImg.mas_bottom).offset(15);
    }];
}
- (void)setEmptyImgSize:(CGSize)emptyImgSize {
    _emptyImgSize = emptyImgSize;
    [_emptyImg mas_updateConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(emptyImgSize);
    }];
}
- (void)hide {
    self.hidden = YES;
}
- (void)setType:(GMToFaceCommonEmptyViewType)type {
    self.hidden = NO;
    switch (type) {
        case GMToFaceCommonEmptyViewTypeEmpty:{
            self.tapBtn.hidden = YES;
            self.emptyImg.image = [UIImage imageNamed:@"empty"];
            self.emptyLabel.text = @"此处太寂寥，社区等你撩";
//            self.emptyImgSize = CGSizeMake(175, 199);
            break;
        }
        case GMToFaceCommonEmptyViewTypeError:{
            self.tapBtn.hidden = NO;
            self.emptyImg.image = [UIImage imageNamed:@"network_failed"];
            self.emptyLabel.text = @"原谅我一看到美人就不淡定";
        }
        default:
            break;
    }
}
- (void)reloadBtnTap {
    self.hidden = YES;
    if ([self.delegate respondsToSelector:@selector(emptyViewDidClickReload)]) {
        [self.delegate emptyViewDidClickReload];
    }
}
- (GMButton *)tapBtn {
    if (!_tapBtn) {
        _tapBtn = [GMButton buttonWithCustomType:GMButtonTypeRedSemicircleGradient];
        _tapBtn.hidden = YES;
        [_tapBtn setTitle:@"重新加载" forState:UIControlStateNormal];
        _tapBtn.titleLabel.font = [UIFont gmFont:16];
        [_tapBtn setTitleColor:UIColor.bodyText forState:UIControlStateNormal];
        [_tapBtn addTarget:self action:@selector(reloadBtnTap) forControlEvents:UIControlEventTouchUpInside];
        
    }
    return _tapBtn;
}
@end
