//
//  GMToFaceDoctorListHorNewCell.m
//  Gengmei
//
//  Created by Jessica on 2020/3/28.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceDoctorListHorNewCell.h"
#import "GMBasicInfoCardView.h"
#import "GMDoctorInfoPopupView.h"
#import "GMConsultantInfoModel.h"
#import "GMToFaceNetworking.h"
#import "GMLibraryHeader.h"
#import "RequestHeader.h"
#import <GMBase/GMBaseTool.h>
@interface GMToFaceDoctorListHorNewCell ()<GMDoctorInfoPopupViewDelegate>
/** 形象照 */
@property (nonatomic, strong) UIImageView *personalIcon;
/** 医生图片 */
@property (nonatomic, strong) UIImageView *docIcon;
/** 渐变背景图片 */
@property (nonatomic, strong) UIImageView *bgImageView;
/** 医生状态 */
@property (nonatomic, strong) UIView *statusView;
/** 医生姓名 */
@property (nonatomic, strong) GMLabel *docNameLabel;
/** 价格 */
@property (nonatomic, strong) GMLabel *priceLabel;

@end
@implementation GMToFaceDoctorListHorNewCell
- (void)setup {
    [super setup];
    [self setUI];
    [self setLayout];
    self.contentView.backgroundColor = UIColor.whiteColor;
    self.layer.cornerRadius = 8.f;
    self.layer.masksToBounds = YES;
}
- (void)setUI {
    [self.contentView addSubview:self.personalIcon];
    [self.contentView addSubview:self.statusView];
    [self.contentView addSubview:self.bgImageView];
    [self.contentView addSubview:self.docIcon];
    [self.contentView addSubview:self.docNameLabel];
    [self.contentView addSubview:self.priceLabel];
}
- (void)setLayout {
    [self.personalIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(UIEdgeInsetsZero);
    }];
    
    [self.statusView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(18);
        make.left.mas_equalTo(7);
        make.top.mas_equalTo(7);
    }];
    
    [self.bgImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(58);
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    [self.docIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(20, 20));
        make.left.mas_equalTo(10);
        make.bottom.mas_equalTo(-10);
    }];
    
    [self.docNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.docIcon.mas_right).offset(7);
        make.height.mas_equalTo(16);
        make.centerY.mas_equalTo(self.docIcon.mas_centerY);
    }];
    
    [self.priceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-10);
        make.height.mas_equalTo(16);
        make.bottom.mas_equalTo(self.docNameLabel.mas_bottom);
    }];
}

- (void)setDoctorsModel:(GMToFaceRecommendsDoctors *)doctorsModel {
    _doctorsModel = doctorsModel;
    if (doctorsModel.name.length > 6) {
        doctorsModel.name = [NSString stringWithFormat:@"%@...",[doctorsModel.name substringWithRange:NSMakeRange(0, 6)]];
    }
    //1(不在线)/2(在线)/3(视频面诊中)
    self.statusView.hidden = doctorsModel.status != 2;
    [self.statusView.subviews enumerateObjectsUsingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if (idx == 0) {
            UIImageView *imageView = (UIImageView *)obj;
            if (doctorsModel.status == 2) {
                imageView.image = [UIImage imageNamed:@"to_face_online_icon"];
            }else if (doctorsModel.status == 3) {
                imageView.image = [UIImage imageNamed:@"to_face_ing_icon"];
            }
        } else {
            GMLabel *label = (GMLabel *)obj;
            if (doctorsModel.status == 2) {
                label.text = @"在线可面诊";
            }else if (doctorsModel.status == 3) {
                label.text = @"面诊中";
            }
        }
    }];
    [self.docIcon sd_setImageWithURL:[NSURL URLWithString:doctorsModel.portrait]];
    [self.personalIcon sd_setImageWithURL:[NSURL URLWithString:doctorsModel.personalPicture]];
    self.docNameLabel.text = SafeString(doctorsModel.name);
    
    if ([doctorsModel.serviceFeeStr isEqualToString:@"免费"]) {
        self.priceLabel.text = doctorsModel.serviceFeeStr;
    }else {
        NSString *str = [NSString stringWithFormat:@"￥%@/单",doctorsModel.serviceFeeStr];
        NSMutableAttributedString *attribute = [[NSMutableAttributedString alloc] initWithString:str];
        NSRange range = [str rangeOfString:@"/"];
        [attribute addAttributes:@{NSFontAttributeName: [UIFont gmBoldFont:10]} range:NSMakeRange(range.location, str.length - range.location)];
        [attribute addAttributes:@{NSFontAttributeName: [UIFont gmBoldFont:12]} range:NSMakeRange(0, 1)];
        [attribute addAttributes:@{NSForegroundColorAttributeName: RGBCOLOR_HEX(0xFFFFFF) } range:NSMakeRange(range.location, str.length - range.location)];
        self.priceLabel.attributedText = attribute;
    }
    self.exposure = doctorsModel.exposure;
}

- (void)clickUserIconMethod {
    [GMBaseTool getCurrentViewController].tabName = @"医生推荐";
    [Phobos track:@"on_click_card" attributes:@{ @"page_name":[GMBaseTool getCurrentViewController].pageName,
                                                 @"tab_name":@"医生推荐",
                                                 @"position":@(self.indexPath.item),
                                                 @"card_id":SafeString(self.doctorsModel.counsellorId),
                                                 @"card_type":@"card",
                                                 @"transaction_type":@"-1",
                                                 @"card_content_type":@"doctor",
                                                 @"in_page_pos":@"middle",
                                                 @"card_status":@(self.doctorsModel.status),
                                                 @"card_name":SafeString(self.doctorsModel.name),
                                                 @"good_at_project":SafeString(self.doctorsModel.goodAt),
                                                 @"counsellor_type":@(self.doctorsModel.type),
                                                 @"is_doctor_assistant":@(self.doctorsModel.isAssistant)
    }];
}
- (void)clickBottomBtnMethod {
    [GMBaseTool getCurrentViewController].tabName = @"医生推荐";
    [Phobos track:@"on_click_card" attributes:@{ @"page_name":[GMBaseTool getCurrentViewController].pageName,
                                                 @"tab_name":@"医生推荐",
                                                 @"position":@(self.indexPath.item),
                                                 @"card_id":SafeString(self.doctorsModel.counsellorId),
                                                 @"card_type":@"card",
                                                 @"transaction_type":@"-1",
                                                 @"card_content_type":@"doctor",
                                                 @"in_page_pos":@"bottom",
                                                 @"card_status":@(self.doctorsModel.status),
                                                 @"card_name":SafeString(self.doctorsModel.name),
                                                 @"good_at_project":SafeString(self.doctorsModel.goodAt),
                                                 @"counsellor_type":@(self.doctorsModel.type),
                                                 @"is_doctor_assistant":@(self.doctorsModel.isAssistant)
    }];
}
- (void)counsellorFillInfoView {
    //填写信息卡片
    __weak __typeof(self)weakSelf = self;
    [[GMToFaceNetworking shareInstance] excuteToFaceBlockInfoSuccessBlock:^(id response) {
        NSDictionary *dict = response[@"block_info"];
        NSString *alert = dict[@"alert"];
        if (![alert isNonEmpty]) {
            //请求用户填面诊信息的弹框
            GMBasicInfoCardView *cardView = [GMBasicInfoCardView new];
            cardView.referer = [GMBaseTool getCurrentViewController].pageName;
            cardView.counsellorId = weakSelf.doctorsModel.counsellorId;
            cardView.doctorId = weakSelf.doctorsModel.doctorId;
            cardView.tabName = @"医生推荐";
            [GMBasicInfoCardView showWithCorrectFrameView:cardView resultBlock:^{
                weakSelf.personalIcon.userInteractionEnabled = YES;
            }];
        } else {
            if (weakSelf.blockInfoCallback) {
                weakSelf.blockInfoCallback(alert);
            }
            weakSelf.personalIcon.userInteractionEnabled = YES;
        }
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        [GMHudModule toast:message];
        weakSelf.personalIcon.userInteractionEnabled = YES;
    }];
}
- (void)counsellorInfoView {
    //弹出面诊师卡片
    __weak __typeof(self)weakSelf = self;
    [GMNetworking requestOCWithApi:API_CONSULTATION__COUNSEL_CONSULTANT method:GMHTTPMethodGet parameters:@{@"counsellor_id": SafeString(self.doctorsModel.counsellorId)} completion:^(GMResponseOC * response) {
        weakSelf.personalIcon.userInteractionEnabled = YES;
        if (response.isSuccess) {
            GMConsultantInfoModel *model = [[GMConsultantInfoModel alloc] initWithDictionary:response.data error:NULL];
            GMDoctorInfoPopupView *popupView = [[GMDoctorInfoPopupView alloc] init];
            popupView.tabName = @"医生推荐";
            popupView.blockInfoCallback = ^(NSString *blockInfo) {
                if (weakSelf.blockInfoCallback) {
                    weakSelf.blockInfoCallback(blockInfo);
                }
            };
            popupView.delegate = weakSelf;
            popupView.model = model;
            [[GMBaseTool getCurrentViewController].view addSubview:popupView];
            weakSelf.personalIcon.userInteractionEnabled = YES;
        } else {
            [[GMBaseTool getCurrentViewController] toast:response.message];
            weakSelf.personalIcon.userInteractionEnabled = YES;
        }
    }];
}

#pragma mark - 医生头像
- (void)docIconClickMethod {
    [GMBaseTool getCurrentViewController].tabName = @"医生推荐";
    self.personalIcon.userInteractionEnabled = NO;
    // 若该医生为在线可面诊状态，则拉起基本信息卡，若为面诊中/不在线状态，跳转医生详情页/或者弹出面诊师卡片
    if ( self.doctorsModel.status == 2) { // 在线状态
        [self counsellorFillInfoView];
        // 埋点
        [self clickBottomBtnMethod];
    } else {
        if (self.doctorsModel.type == 1) {
            //跳到医生主页
            [[GMRouter sharedInstance] pushScheme:self.doctorsModel.gm_url];
            self.personalIcon.userInteractionEnabled = YES;
        } else {
            [self counsellorInfoView];
        }
        // 埋点
        [self clickUserIconMethod];
    }
}

- (UIImageView *)docIcon {
    if (!_docIcon) {
        _docIcon = [[UIImageView alloc] init];
        _docIcon.layer.cornerRadius = 10.f;
        _docIcon.layer.masksToBounds = YES;
        _docIcon.contentMode = UIViewContentModeScaleAspectFill;
    }
    return _docIcon;
}
- (UIImageView *)personalIcon {
    if (!_personalIcon) {
        _personalIcon = [[UIImageView alloc] init];
        _personalIcon.userInteractionEnabled = YES;
        UITapGestureRecognizer *gesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(docIconClickMethod)];
        [_personalIcon addGestureRecognizer:gesture];
        _personalIcon.contentMode = UIViewContentModeScaleAspectFill;

    }
    return _personalIcon;
}

- (UIImageView *)bgImageView {
    if (!_bgImageView) {
        _bgImageView = [[UIImageView alloc] init];
        _bgImageView.contentMode = UIViewContentModeScaleAspectFill;
        [_bgImageView setImage:[UIImage imageNamed:@"to_face_list_recommand_bg"]];
    }
    return _bgImageView;
}
- (GMLabel *)docNameLabel {
    if (!_docNameLabel) {
        _docNameLabel = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:12];
        _docNameLabel.textAlignment = NSTextAlignmentLeft;
    }
    return _docNameLabel;
}

- (UIView *)statusView {
    if (!_statusView) {
        _statusView = [[UIView alloc] init];
        _statusView.backgroundColor = [UIColor colorWithHex:000000 alpha:0.5];
        _statusView.layer.cornerRadius = 9.f;
        _statusView.layer.masksToBounds = YES;
        UIImageView *corView = [[UIImageView alloc] init];
        corView.layer.cornerRadius = 8.f;
        corView.layer.masksToBounds = YES;
        [_statusView addSubview:corView];
        [corView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(2);
            make.size.mas_equalTo(CGSizeMake(16, 16));
            make.centerY.mas_equalTo(0);
        }];
        GMLabel *label = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:10];
        [_statusView addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_equalTo(0);
            make.left.mas_equalTo(corView.mas_right).offset(3);
            make.right.mas_equalTo(-7);
        }];
    }
    return _statusView;
}
- (GMLabel *)priceLabel {
    if (!_priceLabel) {
        _priceLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0xFF8C8D) fontSize:16];
        _priceLabel.font = [UIFont gmBoldFont:16];
    }
    return _priceLabel;
}

@end
