//
//  GMToFaceDoctorListVerCell.m
//  Gengmei
//
//  Created by zhouLiang on 2020/2/18.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceDoctorListVerCell.h"

@interface GMToFaceDoctorInfoView()
/** 好评率 */
@property (nonatomic, copy) NSString *likeRate;
/** 接通率 */
@property (nonatomic, copy) NSString *connectRate;
/** 有效面诊人数 */
@property (nonatomic, copy) NSString *consultPeopleNumber;
/** 展示类型,0: 好评率 + 接通率 1: 好评率 + 有效面诊人数 2: 不展示*/
@property (nonatomic, assign) NSInteger showType;
@property (nonatomic, strong) UIImageView *icon;
@property (nonatomic, strong) UIImageView *icon1;
@property (nonatomic, strong) GMLabel *label;
@property (nonatomic, strong) GMLabel *label1;


@end
@implementation GMToFaceDoctorInfoView
- (void)setup {
    [super setup];
    self.layer.cornerRadius = 7.5f;
    self.layer.masksToBounds = YES;
    self.backgroundColor = [UIColor colorWithHex:000000 alpha:0.4];
}

- (void)showWithLikeRate:(NSString *)likeRate connectRate:(NSString *)connectRate consultPeopleNumber:(NSString *)consultPeopleNumber  showType:(NSInteger)showType {
    [self removeAllSubviews];
    // 规则：有效面诊人数<100人，则展示：
           // 好评率xx%+接通率xx%
           // 有效面诊人数≥100人,则展示：
           // 好评率xx%+有效面诊人数
    // 0：不显示1: 好评率 + 接通率 2: 好评率 + 有效面诊人数
    if (showType == 2) {
        if (likeRate.isNonEmpty && consultPeopleNumber.isNonEmpty) {
            [self addSubview:self.icon];
            [self addSubview:self.label];
            [self addSubview:self.icon1];
            [self addSubview:self.label1];
            
            _icon.image = [UIImage imageNamed:@"to_face_like_rate"];
            _label.text = [NSString stringWithFormat:@"好评%@", likeRate];
            _icon1.image = [UIImage imageNamed:@"to_face_people_num"];
            _icon1.backgroundColor = [UIColor clearColor];
            _label1.text = [NSString stringWithFormat:@"有效面诊%@", consultPeopleNumber];
            
            [_icon mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(5);
                make.size.mas_equalTo(CGSizeMake(10, 10));
                make.centerY.mas_equalTo(0);
            }];
            
            [_label mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(0);
                make.left.mas_equalTo(_icon.mas_right).offset(3);
            }];
            
            [_icon1 mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(_label.mas_right).offset(8);
                make.size.mas_equalTo(CGSizeMake(10, 10));
                make.centerY.mas_equalTo(0);
            }];
            
            [_label1 mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(0);
                make.left.mas_equalTo(_icon1.mas_right).offset(3);
                make.right.mas_equalTo(-5);
            }];
            
        } else {
            [self addSubview:self.icon];
            [self addSubview:self.label];
            if (consultPeopleNumber.isNonEmpty) {
                _icon.image = [UIImage imageNamed:@"to_face_people_num"];
                _label.text = [NSString stringWithFormat:@"有效面诊%@", consultPeopleNumber];
            } else {
                _icon.image = [UIImage imageNamed:@"to_face_like_rate"];
                _label.text = [NSString stringWithFormat:@"好评%@", likeRate];
            }
            
            [_icon mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(5);
                make.size.mas_equalTo(CGSizeMake(10, 10));
                make.centerY.mas_equalTo(0);
            }];
            
            [_label mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(0);
                make.left.mas_equalTo(_icon.mas_right).offset(3);
                make.right.mas_equalTo(-5);
            }];
            
        }
    } else {
        if (likeRate.isNonEmpty && connectRate.isNonEmpty) {
            [self addSubview:self.icon];
            [self addSubview:self.label];
            [self addSubview:self.icon1];
            [self addSubview:self.label1];
            
            _icon.image = [UIImage imageNamed:@"to_face_like_rate"];
            _label.text = [NSString stringWithFormat:@"好评%@", likeRate];
            _icon1.backgroundColor = RGBCOLOR_HEX(0x44D7B6);
            _icon1.layer.cornerRadius = 2;
            _icon1.layer.masksToBounds = YES;
            _icon1.image = [UIImage imageNamed:@""];
            _label1.text = [NSString stringWithFormat:@"接通率%@", connectRate];
            
            [_icon mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(5);
                make.size.mas_equalTo(CGSizeMake(10, 10));
                make.centerY.mas_equalTo(0);
            }];
            
            [_label mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(0);
                make.left.mas_equalTo(_icon.mas_right).offset(3);
            }];
            
            [_icon1 mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(_label.mas_right).offset(8);
                make.size.mas_equalTo(CGSizeMake(4, 4));
                make.centerY.mas_equalTo(0);
            }];
            
            [_label1 mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(0);
                make.left.mas_equalTo(_icon1.mas_right).offset(3);
                make.right.mas_equalTo(-5);
            }];
            
        } else {
            if (connectRate.isNonEmpty) {
                [self addSubview:self.icon1];
                [self addSubview:self.label1];
                _icon1.backgroundColor = RGBCOLOR_HEX(0x44D7B6);
                _icon1.layer.cornerRadius = 2;
                _icon1.layer.masksToBounds = YES;
                _icon1.image = [UIImage imageNamed:@""];
                _label1.text = [NSString stringWithFormat:@"接通率%@", connectRate];
                [_icon1 mas_remakeConstraints:^(MASConstraintMaker *make) {
                    make.left.mas_equalTo(5);
                    make.size.mas_equalTo(CGSizeMake(4, 4));
                    make.centerY.mas_equalTo(0);
                }];
                
                [_label1 mas_remakeConstraints:^(MASConstraintMaker *make) {
                    make.centerY.mas_equalTo(0);
                    make.left.mas_equalTo(_icon1.mas_right).offset(3);
                    make.right.mas_equalTo(-5);
                }];
            } else {
                [self addSubview:self.icon];
                [self addSubview:self.label];
                _icon.image = [UIImage imageNamed:@"to_face_people_num"];
                _label.text = [NSString stringWithFormat:@"有效面诊%@", consultPeopleNumber];
                [_icon mas_remakeConstraints:^(MASConstraintMaker *make) {
                    make.left.mas_equalTo(5);
                    make.size.mas_equalTo(CGSizeMake(10, 10));
                    make.centerY.mas_equalTo(0);
                }];
                
                [_label mas_remakeConstraints:^(MASConstraintMaker *make) {
                    make.centerY.mas_equalTo(0);
                    make.left.mas_equalTo(_icon.mas_right).offset(3);
                    make.right.mas_equalTo(-5);
                }];
            }
            
            
        }
        
    }
}

- (UIImageView *)icon {
    if (!_icon) {
        _icon = [[UIImageView alloc] init];
    }
    return _icon;
}

- (UIImageView *)icon1 {
    if (!_icon1) {
        _icon1 = [[UIImageView alloc] init];
    }
    return _icon1;
}

- (GMLabel *)label {
    if (!_label) {
        _label = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:10];
    }
    return _label;
}

- (GMLabel *)label1 {
    if (!_label1) {
        _label1 = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:10];
    }
    return _label1;
}
@end
@interface GMToFaceDoctorListVerCell ()
/** 医生图片 */
@property (nonatomic, strong) UIImageView *docIcon;
/** 医生状态 */
@property (nonatomic, strong) UIView *statusView;
/** 医生姓名 */
@property (nonatomic, strong) GMLabel *docNameLabel;
/** 价格 */
@property (nonatomic, strong) GMLabel *priceLabel;
/** 医生执业时间 */
@property (nonatomic, strong) GMLabel *docWorkTimeLabel;
/** 医生所在地点 */
@property (nonatomic, strong) UIView *positionView;
/** 擅长项目 */
@property (nonatomic, strong) GMLabel *goodAtLabel;
/** 医生称呼 */
@property (nonatomic, strong) UIView *docTitleView;
/** 有效面诊人数、接通率、好评率 */
@property (nonatomic, strong) GMToFaceDoctorInfoView *infoView;
@end

@implementation GMToFaceDoctorListVerCell
- (void)setup {
    [super setup];
    [self setUI];
    [self setLayout];
    self.contentView.backgroundColor = UIColor.whiteColor;
    self.layer.cornerRadius = 8.f;
    self.layer.masksToBounds = YES;
}
- (void)setUI {
    [self.contentView addSubview:self.docIcon];
    [self.docIcon addSubview:self.statusView];
    [self.docIcon addSubview:self.infoView];
    [self.contentView addSubview:self.docTitleView];
    [self.contentView addSubview:self.docNameLabel];
    [self.contentView addSubview:self.docWorkTimeLabel];
    [self.contentView addSubview:self.goodAtLabel];
    [self.contentView addSubview:self.priceLabel];
}
- (void)setLayout {
    [self.docIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.right.mas_equalTo(0);
        make.width.height.mas_equalTo((MAINSCREEN_WIDTH - 32) / 2);
    }];
    
    [self.statusView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(18);
        make.left.mas_equalTo(7);
        make.top.mas_equalTo(7);
    }];
    
    [self.infoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(18);
        make.left.mas_equalTo(7);
        make.right.mas_lessThanOrEqualTo(-7);
        make.bottom.mas_equalTo(-7);
    }];

    [self.docNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(8);
        make.height.mas_equalTo(14);
        make.top.equalTo(self.docIcon.mas_bottom).offset(10);
    }];
    
    [self.priceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-10);
        make.height.mas_equalTo(18);
        make.centerY.equalTo(self.docNameLabel.mas_centerY);
    }];
    
    [self.docTitleView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.docNameLabel.mas_left);
        make.height.mas_equalTo(15);
        make.top.mas_equalTo(self.docNameLabel.mas_bottom).offset(11.5);
    }];
    
    [self.docWorkTimeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.docTitleView.mas_right).offset(4);
        make.centerY.equalTo(self.docTitleView.mas_centerY);
    }];
    [self.goodAtLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.docTitleView.mas_left);
        make.top.equalTo(self.docTitleView.mas_bottom).offset(9.5);
        make.right.mas_equalTo(-8);
        make.bottom.mas_equalTo(-10);
    }];
}
- (void)setDoctorsModel:(GMToFaceRecommendsDoctors *)doctorsModel {
    _doctorsModel = doctorsModel;
    self.exposure = doctorsModel.exposure;
    if (doctorsModel.name.length > 6) {
        doctorsModel.name = [NSString stringWithFormat:@"%@...",[doctorsModel.name substringWithRange:NSMakeRange(0, 6)]];
    }
    [self.docIcon sd_setImageWithURL:[NSURL URLWithString:SafeString(doctorsModel.personalPicture)]];
    //医生状态
    [self doctorStatusMethod];
    //医生身份
    [self doctorIdentity];
    
    self.infoView.hidden = doctorsModel.showType == 0;
    [self.infoView showWithLikeRate:doctorsModel.likeRate connectRate:doctorsModel.connectRate consultPeopleNumber:doctorsModel.consultPeopleNumber showType:doctorsModel.showType];
    
    self.docNameLabel.text = SafeString(doctorsModel.name);
    self.docWorkTimeLabel.text = [NSString stringWithFormat:@"从业%@年",doctorsModel.practisingTime];
    self.docWorkTimeLabel.hidden = [doctorsModel.practisingTime isEqualToString:@"0"];
    self.positionView.hidden = [doctorsModel.cityName isNonEmpty] ? NO:YES;
    [self.positionView.subviews enumerateObjectsUsingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if (idx == 1) {
            GMLabel *label = (GMLabel *)obj;
            label.text = SafeString(doctorsModel.cityName);
        }
    }];
    if ([doctorsModel.goodAt isNonEmpty]) {
        self.goodAtLabel.text = [NSString stringWithFormat:@"擅长：%@",doctorsModel.goodAt];
    }
    if ([doctorsModel.serviceFeeStr isEqualToString:@"免费"]) {
        self.priceLabel.text = doctorsModel.serviceFeeStr;
    }else {
        NSString *str = [NSString stringWithFormat:@"￥%@ /单",doctorsModel.serviceFeeStr];
        NSRange range = [str rangeOfString:@"/"];
        range = NSMakeRange(range.location, str.length - range.location);
        NSMutableAttributedString *attribute = [[NSMutableAttributedString alloc] initWithString:str];
        [attribute addAttributes:@{NSForegroundColorAttributeName : RGBCOLOR_HEX(0x8E8E8E) } range:range];
        [attribute addAttributes:@{NSFontAttributeName : [UIFont gmFont:12]} range:range];
        self.priceLabel.attributedText = attribute;
    }
}
#pragma mark - 医生状态
- (void)doctorStatusMethod {
    //1(不在线)/2(在线)/3(视频面诊中)
    self.statusView.hidden = self.doctorsModel.status == 1;
    [self.statusView.subviews enumerateObjectsUsingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if (idx == 0) {
            UIImageView *imageView = (UIImageView *)obj;
            if (self.doctorsModel.status == 2) {
                imageView.image = [UIImage imageNamed:@"to_face_online_icon"];
            }else if (self.doctorsModel.status == 3) {
                imageView.image = [UIImage imageNamed:@"to_face_ing_icon"];
            }
        } else {
            GMLabel *label = (GMLabel *)obj;
            if (self.doctorsModel.status == 2) {
                label.text = @"在线可面诊";
            }else if (self.doctorsModel.status == 3) {
                label.text = @"面诊中";
            }
        }
    }];
}
#pragma mark - 医生身份
- (void)doctorIdentity {
    if (self.doctorsModel.type == 1) { // 医生
        _docTitleView.layer.borderColor = RGBCOLOR_HEX(0x65B4FF).CGColor;
    } else if (self.doctorsModel.type == 2) {
        _docTitleView.layer.borderColor = RGBCOLOR_HEX(0x51CDC7).CGColor;
    }
    [self.docTitleView.subviews enumerateObjectsUsingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if (idx == 0) {
            UIImageView *imageView = (UIImageView *)obj;
            if (self.doctorsModel.type == 1) { // 医生
                imageView.image = [UIImage imageNamed:@"to_face_doctor_icon"];
            }else if (self.doctorsModel.type == 2) { // 面诊师
                imageView.image = [UIImage imageNamed:@"to_face_counsellor_icon"];
            }
        } else {
            GMLabel *label = (GMLabel *)obj;
            label.text = SafeString(self.doctorsModel.title);
            if (self.doctorsModel.type == 1) { // 医生
                label.textColor = RGBCOLOR_HEX(0x65B4FF);
            }else if (self.doctorsModel.type == 2) { // 面诊师
                label.textColor = RGBCOLOR_HEX(0x51CDC7);
            }
        }
    }];
}
- (UIImageView *)docIcon {
    if (!_docIcon) {
        _docIcon = [[UIImageView alloc] init];
        _docIcon.contentMode = UIViewContentModeScaleAspectFill;
        _docIcon.clipsToBounds = YES;
    }
    return _docIcon;
}
- (UIView *)statusView {
    if (!_statusView) {
        _statusView = [[UIView alloc] init];
        _statusView.backgroundColor = [UIColor colorWithHex:000000 alpha:0.5];
        _statusView.layer.cornerRadius = 9.f;
        _statusView.layer.masksToBounds = YES;
        UIImageView *corView = [[UIImageView alloc] init];
        corView.layer.cornerRadius = 8.f;
        corView.layer.masksToBounds = YES;
        [_statusView addSubview:corView];
        [corView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(2);
            make.size.mas_equalTo(CGSizeMake(16, 16));
            make.centerY.mas_equalTo(0);
        }];
        GMLabel *label = [GMLabel labelWithTextColor:UIColor.whiteColor fontSize:10];
        [_statusView addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_equalTo(0);
            make.left.mas_equalTo(corView.mas_right).offset(3);
            make.right.mas_equalTo(-7);
        }];
    }
    return _statusView;
}

- (UIView *)docTitleView {
    if (!_docTitleView) {
        _docTitleView = [[UIView alloc] init];
        _docTitleView.layer.cornerRadius = 7.5f;
        _docTitleView.layer.masksToBounds = YES;
        _docTitleView.layer.borderColor = RGBCOLOR_HEX(0x65B4FF).CGColor;
        _docTitleView.layer.borderWidth = ONE_PIXEL;
        UIImageView *corView = [[UIImageView alloc] init];
        corView.layer.cornerRadius = 7.5f;
        corView.layer.masksToBounds = YES;
        [_docTitleView addSubview:corView];
        [corView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(0);
            make.size.mas_equalTo(CGSizeMake(15, 15));
            make.centerY.mas_equalTo(0);
        }];
        GMLabel *label = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x65B4FF) fontSize:10];
        [_docTitleView addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_equalTo(0);
            make.left.mas_equalTo(corView.mas_right).offset(3);
            make.right.mas_equalTo(-7);
        }];
    }
    return _docTitleView;
}

- (UIView *)infoView {
    if (!_infoView) {
        _infoView = [[GMToFaceDoctorInfoView alloc] init];
    }
    return _infoView;
}

- (GMLabel *)docNameLabel {
    if (!_docNameLabel) {
        _docNameLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:14];
        _docNameLabel.font = [UIFont gmFont:14];
    }
    return _docNameLabel;
}

- (GMLabel *)docWorkTimeLabel {
    if (!_docWorkTimeLabel) {
        _docWorkTimeLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x8E8E8E)  fontSize:12];
    }
    return _docWorkTimeLabel;
}

- (UIView *)positionView {
    if (!_positionView) {
        _positionView = [[UIView alloc] init];
        UIImageView *icon = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"cityLocatedBlue"]];
        [_positionView addSubview:icon];
        [icon mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(14, 14));
            make.left.mas_equalTo(0);
            make.centerY.equalTo(_positionView.mas_centerY);
        }];
        GMLabel *label = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x8E8E8E)  fontSize:10];
        [_positionView addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
           make.left.equalTo(icon.mas_right).offset(2);
           make.centerY.equalTo(_positionView.mas_centerY);
        }];
    }
    return _positionView;
}
- (GMLabel *)goodAtLabel {
    if (!_goodAtLabel) {
        _goodAtLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:12];
        _goodAtLabel.font = [UIFont gmFont:12];
        _goodAtLabel.numberOfLines = 2;
    }
    return _goodAtLabel;
}
- (GMLabel *)priceLabel {
    if (!_priceLabel) {
        _priceLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0xFF8C8D) fontSize:16];
        _priceLabel.font = [UIFont gmBoldFont:16];
    }
    return _priceLabel;
}
@end
