//
//  GMPayTypeView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/4/10.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPayTypeView.h"
#import "GMLibraryHeader.h"

@interface GMPayTypeView ()
@property (strong, nonatomic) UIImageView *payWayImage;
@property (strong, nonatomic) GMLabel *payName;
@property (strong, nonatomic) GMLabel *payDesc;
/** 后面勾选的状态 */
@property (strong, nonatomic) GMButton *statusButton;
/** 推荐icon */
@property (strong, nonatomic) UIImageView *recommendIcon;
@end

@implementation GMPayTypeView

- (instancetype)init {
    if (self = [super init]) {
        [self setUI];
        [self setLayout];
    }
    return self;
}
- (void)setTypeModel:(GMToFacePayTypeModel *)typeModel {
    _typeModel = typeModel;
    [self.payWayImage sd_setImageWithURL:[NSURL URLWithString:typeModel.icon]];
    self.payDesc.text = typeModel.desc;
    self.payName.text = typeModel.title;
    self.payDesc.textColor = typeModel.recommend?RGBCOLOR_HEX(0xFF5963):RGBCOLOR_HEX(0x999999);
    self.recommendIcon.hidden = !typeModel.recommend;
}
- (void)setIsSelected:(BOOL)isSelected {
    self.statusButton.selected = isSelected;
}
- (void)setUI {
    [self addSubview:self.payWayImage];
    [self addSubview:self.payName];
    [self addSubview:self.payDesc];
    [self addSubview:self.statusButton];
    [self addSubview:self.recommendIcon];
}
- (void)setLayout {
    [self.payWayImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(40, 40));
        make.centerY.mas_equalTo(0);
        make.left.mas_equalTo(15);        
    }];
    [self.payName mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.payWayImage.mas_right).offset(12);
        make.top.equalTo(self.payWayImage.mas_top).offset(4);
        make.height.mas_equalTo(15);
        make.right.mas_equalTo(-100);
    }];
    [self.payDesc mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.payName.mas_left);
        make.bottom.equalTo(self.payWayImage.mas_bottom).offset(-4);
        make.height.mas_equalTo(13);
        make.right.mas_equalTo(-100);
    }];
    [self.statusButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(18, 18));
        make.centerY.equalTo(self.payWayImage.mas_centerY);
        make.right.equalTo(self.mas_right).offset(-15);
    }];
    [self.recommendIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(32, 16));
        make.top.equalTo(self.statusButton.mas_top);
        make.right.equalTo(self.statusButton.mas_left).offset(-18);
    }];
}
- (UIImageView *)payWayImage {
    if (!_payWayImage) {
        _payWayImage = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"gm_pay_zhifubao"]];
    }
    return _payWayImage;
}
- (GMLabel *)payName {
    if (!_payName) {
        _payName = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:14];
        _payName.text = @"支付宝支付";
    }
    return _payName;
}
- (GMLabel *)payDesc {
    if (!_payDesc) {
        _payDesc = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0xFF5963) fontSize:12];
        _payDesc.text = @"推荐使用支付宝支付";
    }
    return _payDesc;
}
- (UIImageView *)recommendIcon {
    if (!_recommendIcon) {
        _recommendIcon = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"pay_recommend"]];
    }
    return _recommendIcon;
}
- (GMButton *)statusButton {
    if (!_statusButton) {
        _statusButton = [GMButton buttonWithType:(UIButtonTypeCustom)];
        [_statusButton setImage:[UIImage imageNamed:@"cart_huiduihao"] forState:(UIControlStateNormal)];
        [_statusButton setImage:[UIImage imageNamed:@"cart_duihao"] forState:(UIControlStateSelected)];
    }
    return _statusButton;
}
@end
