//
//  GMSureOrderPopView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/4/7.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMSureOrderPopView.h"
#import "GMEndConsultView.h"
#import "GMStarWithContentObject.h"
#import "GMToFaceNetworking.h"
#import <GMBase/GMBaseTool.h>


@interface GMSureOrderPopView ()
@property (nonatomic, strong) GMLabel *topLabel;
@property (nonatomic, strong) UIImageView *headerIcon;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMLabel *nameLabel;
@property (nonatomic, strong) GMLabel *startTimeLabel;
@property (nonatomic, strong) GMLabel *endTimeLabel;
/** 时长 */
@property (nonatomic, strong) GMLabel *durationLabel;
/** 价格 */
@property (nonatomic, strong) GMLabel *priceLabel;
/** 实际支付价格 */
@property (nonatomic, strong) GMLabel *payLabel;
/** 确定订单 */
@property (nonatomic, strong) GMButton *sureBtn;
/** 问题申诉 */
@property (nonatomic, strong) GMButton *problemBtn;
/** 埋点参数 */
@property (nonatomic, assign) NSInteger counsellorType;
@property (nonatomic, assign) NSInteger consultationType;
@property (nonatomic, copy) NSString *doctorId;
//右上角关闭按钮
@property (nonatomic, strong) GMButton *cancelButton;
//确认过订单就不用再次确认订单了
@property (nonatomic, assign) BOOL isSureOrder;
@end

@implementation GMSureOrderPopView

- (void)setup {
    [super setup];
    [self setUI];
    [self setLayout];
}
- (void)setUI {
    [self.container addSubview:self.topLabel];
    [self.container addSubview:self.headerIcon];
    [self.container addSubview:self.titleLabel];
    [self.container addSubview:self.nameLabel];
    [self.container addSubview:self.startTimeLabel];
    [self.container addSubview:self.endTimeLabel];
    [self.container addSubview:self.durationLabel];
    [self.container addSubview:self.priceLabel];
    [self.container addSubview:self.payLabel];
    [self.container addSubview:self.sureBtn];
    [self.container addSubview:self.problemBtn];
    [self.container addSubview:self.cancelButton];
}
- (void)setLayout {
    [self.topLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.mas_equalTo(25);
        make.height.mas_equalTo(22);
    }];
    [self.headerIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.equalTo(self.topLabel.mas_bottom).offset(15);
        make.size.mas_equalTo(CGSizeMake(80, 80));
    }];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.headerIcon.mas_right).offset(12);
        make.top.equalTo(self.headerIcon.mas_top).offset(4);
    }];
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLabel.mas_right);
        make.top.equalTo(self.headerIcon.mas_top);
    }];
    [self.startTimeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLabel.mas_left);
        make.top.equalTo(self.topLabel.mas_bottom).offset(46);
        make.height.mas_equalTo(16.5);
        make.right.mas_equalTo(-10);
    }];
    [self.endTimeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLabel.mas_left);
        make.top.equalTo(self.startTimeLabel.mas_bottom).offset(2);
        make.height.mas_equalTo(16.5);
        make.right.mas_equalTo(-10);
    }];
    [self.durationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLabel.mas_left);
        make.top.equalTo(self.endTimeLabel.mas_bottom).offset(2);
        make.height.mas_equalTo(16.5);
        make.right.mas_equalTo(-10);
    }];
    [self.priceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLabel.mas_left);
        make.top.equalTo(self.durationLabel.mas_bottom).offset(15);
        make.height.mas_equalTo(16.5);
        make.right.mas_equalTo(-10);
    }];
    [self.payLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLabel.mas_left);
        make.top.equalTo(self.priceLabel.mas_bottom).offset(2);
        make.height.mas_equalTo(16.5);
        make.right.mas_equalTo(-10);
    }];
    [self.sureBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(42);
        make.right.mas_equalTo(-42);
        make.height.mas_equalTo(45);
        make.top.equalTo(self.payLabel.mas_bottom).offset(26);
    }];
    [self.problemBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.sureBtn.mas_bottom).offset(15);
        make.centerX.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(100, 18.5));
        make.bottom.mas_equalTo(-15-UIView.safeAreaInsetsBottom);
    }];
    [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_offset(CGSizeMake(17, 17));
        make.top.mas_offset(20);
        make.right.mas_offset(-20);
    }];
    [self.container mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(316+UIView.safeAreaInsetsBottom);
    }];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self containerRectCorner:self.container];
    });
}

- (void)containerRectCorner:(UIView *)view {
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:view.bounds byRoundingCorners:UIRectCornerTopLeft | UIRectCornerTopRight cornerRadii:CGSizeMake(12, 12)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc] init];
    maskLayer.frame = view.bounds;
    maskLayer.path = maskPath.CGPath;
    view.layer.mask = maskLayer;
}
- (void)setInfoModel:(GMToFaceOrderInfoModel *)infoModel {
    _infoModel = infoModel;
    self.titleLabel.text = infoModel.counsellorType == 1 ? @"面诊医生 | ":@"面诊师 | ";
    [self.headerIcon sd_setImageWithURL:[NSURL URLWithString:infoModel.counsellorPortrait]];
    self.nameLabel.text = infoModel.counsellorName;
    self.startTimeLabel.text = [NSString stringWithFormat:@"面诊开始时间：%@",infoModel.startTime];
    self.endTimeLabel.text = [NSString stringWithFormat:@"面诊结束时间：%@",infoModel.endTime];
    self.durationLabel.text = [NSString stringWithFormat:@"面诊时长：%@",infoModel.consultTime];
    self.priceLabel.text = [NSString stringWithFormat:@"面诊服务费：￥ %@",infoModel.paymentAmountStr];
    self.payLabel.text = [NSString stringWithFormat:@"实际支付：￥ %@",infoModel.needPayStr];
    
    
    NSString *priceStr = self.priceLabel.text;
    NSRange priceRange = [priceStr rangeOfString:@"￥"];
    priceRange = NSMakeRange(priceRange.location, priceStr.length - priceRange.location);
    NSMutableAttributedString *priceAttribute = [[NSMutableAttributedString alloc] initWithString:priceStr];
    [priceAttribute addAttributes:@{NSForegroundColorAttributeName : RGBCOLOR_HEX(0xFF8C8D)} range:priceRange];
    self.priceLabel.attributedText = priceAttribute;
    
    NSString *payStr = self.payLabel.text;
    NSRange payRange = [payStr rangeOfString:@"￥"];
    payRange = NSMakeRange(payRange.location, payStr.length - payRange.location);
    NSMutableAttributedString *payAttribute = [[NSMutableAttributedString alloc] initWithString:payStr];
    [payAttribute addAttributes:@{NSForegroundColorAttributeName : RGBCOLOR_HEX(0xFF8C8D)} range:payRange];
    self.payLabel.attributedText = payAttribute;
}
#pragma mark - 确认订单弹框
- (void)sureBtnClick {
    [self clickPhoboMethod:@"confirm_order"];
    //确认订单
    if (self.isSureOrder) {
        [self starMethod];
    }else {
        [[GMToFaceNetworking shareInstance] excuteToFaceSureOrder:self.infoModel.orderNo SuccessBlock:^(id response) {
            self.isSureOrder = YES;
            [self starMethod];
        } failureBlock:^(NSInteger errorCode, NSString *message) {
            [[GMBaseTool getCurrentViewController] toast:message];
            [self hide];
        }];
    }
}
#pragma mark - 申诉弹框
- (void)problemBtnClickMethod {
    self.alpha = 0.f;
    [self clickPhoboMethod:@"complaint"];
    __weak typeof(self) weakSelf = self;
    GMEndConsultView *view = [[GMEndConsultView alloc] initWithType:GMEndConsultViewTypeUserComplaint starNum:0];
    //投诉完成，原因是订单列表会用到这个值，目的是回传给h5改订单列表的状态
    view.complaintFinish = ^(NSInteger complaintStatus) {
        [weakSelf hide];
        if (weakSelf.completeCallBack) {
            weakSelf.completeCallBack(1, @"", 0);
        }
    };
    //投诉弹框右上角的×的点击,原因是订单列表会用到这个值，目的是回传给h5改订单列表的状态
    view.hideFinish = ^{
        weakSelf.alpha = 1.f;
    };
    view.recordId = self.infoModel.consultationRecordId;
    view.complaintType = GMComplaintTypeDoctor;
    [[GMBaseTool getCurrentViewController].view addSubview:view];
}
- (void)clickConfireBtnPhobo:(NSInteger)counsellorType consultationType:(NSInteger)consultationType doctorId:(NSString *)doctorId {
    _counsellorType = counsellorType;
    _consultationType = consultationType;
    _doctorId = doctorId;
}
- (void)clickPhoboMethod:(NSString *)btnName {
    NSDictionary *dict = @{@"page_name":@"video_face_consultation",
                           @"order_id":self.infoModel.orderNo,
                           @"button_name":btnName,
                           @"counsellor_type":@(_counsellorType),
                           @"consultation_type":@(_consultationType),
                           @"doctor_id":_doctorId
    };
    [Phobos track:@"on_click_button" attributes:dict];
    
}
#pragma mark - 星级评价弹框
- (void)starMethod {
    //是面诊师直接弹评价弹框
    __weak typeof(self) weakSelf = self;
    [[GMToFaceNetworking shareInstance] excuteToFaceEvaluateItemDiagnosis_id:self.infoModel.consultationRecordId SuccessBlock:^(id response) {
        GMStarWithContentObject *starContentModel = [[GMStarWithContentObject alloc] initWithDictionary:response error:nil];
        GMEndConsultView *view = [[GMEndConsultView alloc] initWithType:(GMEndConsultViewTypeGrayStar) starNum:0];
        [weakSelf hide];
        //投诉弹框右上角的×的点击,原因是订单列表会用到这个值，目的是回传给h5改订单列表的状态
        view.hideFinish = ^{
            if (weakSelf.completeCallBack) {
                weakSelf.completeCallBack(0, @"", 0);
            }
        };
        //星级评价,原因是订单列表会用到这个值，目的是回传给h5改订单列表的状态
        view.evaluateFinish = ^(NSInteger type, NSInteger starNum, NSString * _Nonnull evaluateStr) {
            [self hide];
            if (type == 0) {
                //type = 0 是填写评价，所以只有这种情况才是需要回传给h5
                if (weakSelf.completeCallBack) {
                    weakSelf.completeCallBack(2, evaluateStr, starNum);
                }
            }
        };
        view.showComplaint = NO;
        view.recordId = self.infoModel.consultationRecordId;
        view.starContentArray = starContentModel.evaluates;
        [[GMBaseTool getCurrentViewController].view addSubview:view];
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        [self hide];
    }];
}
- (void)setIsCloseBtnHidden:(BOOL)isCloseBtnHidden {
    self.cancelButton.hidden = isCloseBtnHidden;
}
- (void)didTapView {
    
}
- (GMLabel *)topLabel {
    if (!_topLabel) {
        _topLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:16];
        _topLabel.font = [UIFont gmBoldFont:16];
        _topLabel.text = @"请确认视频面诊信息";
    }
    return _topLabel;
}
- (UIImageView *)headerIcon {
    if (!_headerIcon) {
        _headerIcon = [[UIImageView alloc] init];
        _headerIcon.layer.cornerRadius = 40.f;
        _headerIcon.layer.masksToBounds = YES;
    }
    return _headerIcon;
}
- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828)  fontSize:12];
    }
    return _titleLabel;
}
- (GMLabel *)nameLabel {
    if (!_nameLabel) {
        _nameLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828)  fontSize:16];
        _nameLabel.font = [UIFont gmBoldFont:16];
    }
    return _nameLabel;
}
- (GMLabel *)startTimeLabel {
    if (!_startTimeLabel) {
        _startTimeLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:12];
    }
    return _startTimeLabel;
}
- (GMLabel *)endTimeLabel {
    if (!_endTimeLabel) {
        _endTimeLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:12];
    }
    return _endTimeLabel;
}
- (GMLabel *)durationLabel {
    if (!_durationLabel) {
        _durationLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:12];
    }
    return _durationLabel;
}
- (GMLabel *)priceLabel {
    if (!_priceLabel) {
        _priceLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:12];
    }
    return _priceLabel;
}
- (GMLabel *)payLabel {
    if (!_payLabel) {
        _payLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:12];
    }
    return _payLabel;
}
- (GMButton *)sureBtn {
    if (!_sureBtn) {
        _sureBtn = [GMButton buttonWithType:(UIButtonTypeCustom)];
        _sureBtn.multiControlTimeInterva = 2.f;
        [_sureBtn setBackgroundColor:RGBCOLOR_HEX(0xFF8C8D) forState:(UIControlStateNormal)];
        [_sureBtn setTitle:@"确认订单" forState:(UIControlStateNormal)];
        [_sureBtn setTitleColor:UIColor.whiteColor forState:(UIControlStateNormal)];
        [_sureBtn addTarget:self action:@selector(sureBtnClick) forControlEvents:(UIControlEventTouchUpInside)];
        [_sureBtn.titleLabel setFont:[UIFont gmFont:16]];
        _sureBtn.layer.cornerRadius = 22.5f;
        _sureBtn.layer.masksToBounds = YES;
    }
    return _sureBtn;
}
- (GMButton *)problemBtn {
    if (!_problemBtn) {
        _problemBtn = [GMButton buttonWithType:(UIButtonTypeCustom)];
        _problemBtn.multiControlTimeInterva = 2.f;
        [_problemBtn addTarget:self action:@selector(problemBtnClickMethod) forControlEvents:(UIControlEventTouchUpInside)];
        [_problemBtn.titleLabel setFont:[UIFont gmFont:13]];
        _problemBtn.enableAdaptive = YES;
        [_problemBtn setTitle:@"问题申诉>" forState:(UIControlStateNormal)];
        [_problemBtn setTitleColor:RGBCOLOR_HEX(0xFF8C8D) forState:(UIControlStateNormal)];
    }
    return _problemBtn;
}
- (GMButton *)cancelButton {
    if (!_cancelButton) {
        _cancelButton.hidden = YES;
        _cancelButton = [GMButton buttonWithType:UIButtonTypeCustom];
        _cancelButton.enableAdaptive = YES;
        [_cancelButton setBackgroundImage:[UIImage imageNamed:@"wt_cancel_icon"] forState:UIControlStateNormal];
        [_cancelButton addTarget:self action:@selector(hide) forControlEvents:UIControlEventTouchUpInside];
    }
    return _cancelButton;
}

@end
