//
//  GMToFaceOrderFooterView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/4/8.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceOrderFooterView.h"
@import GMBase;

@interface GMToFaceOrderFooterView ()
@property (nonatomic, strong) GMLabel *payNameLabel;
@property (nonatomic, strong) GMLabel *moneyLabel;
@property (nonatomic, strong) GMButton *payBtn;
@property (nonatomic, copy) void(^payBtnBlock)(void);
@end

@implementation GMToFaceOrderFooterView

- (instancetype)initWithClickBlock:(void (^)(void))block {
    if (self = [super init]) {
        self.payBtnBlock = block;
        [self setUI];
        [self setLayout];
        self.backgroundColor = UIColor.whiteColor;
    }
    return self;
}
- (void)setIsCanClick:(BOOL)isCanClick {
    self.payBtn.userInteractionEnabled = isCanClick;
}
- (void)setModel:(GMToFacePayPrepareModel *)model {
    _model = model;
    self.moneyLabel.text = [NSString stringWithFormat:@"￥%@",model.paymentAmountStr];
}
- (void)payBtnClick {
    if (self.payBtnBlock) {
        self.payBtnBlock();
    }
}
- (void)setUI {
    [self addSubview:self.payNameLabel];
    [self addSubview:self.moneyLabel];
    [self addSubview:self.payBtn];
}
- (void)setLayout {
    [self.payNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(18);
    }];
    [self.moneyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.payNameLabel.mas_right);
        make.top.mas_equalTo(18);
    }];
    [self.payBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(112, 40));
        make.top.mas_equalTo(5);
        make.right.mas_equalTo(-15);
    }];
}
- (GMLabel *)payNameLabel {
    if (!_payNameLabel) {
        _payNameLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:14];
        _payNameLabel.text = @"支付金额：";
    }
    return _payNameLabel;
}
- (GMLabel *)moneyLabel {
    if (!_moneyLabel) {
        _moneyLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0xFF8C8D) fontSize:14];
    }
    return _moneyLabel;
}
- (GMButton *)payBtn {
    if (!_payBtn) {
        _payBtn = [GMButton buttonWithType:(UIButtonTypeCustom)];
        [_payBtn addTarget:self action:@selector(payBtnClick) forControlEvents:(UIControlEventTouchUpInside)];
        [_payBtn setBackgroundColor:RGBCOLOR_HEX(0xFF8C8D) forState:(UIControlStateNormal)];
        [_payBtn setTitle:@"立即支付" forState:(UIControlStateNormal)];
        [_payBtn.titleLabel setFont:[UIFont gmBoldFont:16]];
        _payBtn.layer.cornerRadius = 20.f;
        _payBtn.layer.masksToBounds = YES;
    }
    return _payBtn;
}

@end
