//
//  GMToFaceOrderHeaderView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/4/7.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFaceOrderHeaderView.h"
#import "GMLibraryHeader.h"

@interface GMToFaceOrderHeaderView ()
@property (nonatomic, strong) UIImageView *headerIcon;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMLabel *organizationLabel;
@property (nonatomic, strong) GMLabel *moneyLabel;
@property (nonatomic, strong) GMLabel *payLabel;
@end

@implementation GMToFaceOrderHeaderView

- (instancetype)init {
    if (self = [super init]) {
        [self setUI];
        [self setLayout];
    }
    return self;
}
- (void)setModel:(GMToFacePayPrepareModel *)model {
    _model = model;
    [self.headerIcon sd_setImageWithURL:[NSURL URLWithString:SafeString(model.counsellorInfo.portrait)]];
    self.titleLabel.text = model.orderName;
    self.organizationLabel.text = [NSString stringWithFormat:@"机构：%@",model.counsellorInfo.hospitalName];
    
    self.payLabel.text = [NSString stringWithFormat:@"￥%@/单",model.priceStr];
    NSRange range = [self.payLabel.text rangeOfString:@"/"];
    range = NSMakeRange(range.location, self.payLabel.text.length - range.location);
    NSMutableAttributedString *attribute = [[NSMutableAttributedString alloc] initWithString:self.payLabel.text];
    [attribute addAttributes:@{NSForegroundColorAttributeName : RGBCOLOR_HEX(0x999999) } range:range];
    [attribute addAttributes:@{NSFontAttributeName : [UIFont gmFont:10]} range:NSMakeRange(0, 1)];
    self.payLabel.attributedText = attribute;
}
- (void)setUI {
    [self addSubview:self.headerIcon];
    [self addSubview:self.titleLabel];
    [self addSubview:self.organizationLabel];
    [self addSubview:self.moneyLabel];
    [self addSubview:self.payLabel];
}
- (void)setLayout {
    [self.headerIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(70, 70));
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(16);
    }];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.headerIcon.mas_top).offset(-5.5);
        make.left.equalTo(self.headerIcon.mas_right);
        make.height.mas_equalTo(19);
        make.right.mas_equalTo(-10);
    }];
    [self.organizationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.headerIcon.mas_right).offset(9);
        make.top.equalTo(self.titleLabel.mas_bottom).offset(12);
        make.height.mas_equalTo(15);
        make.right.mas_equalTo(-10);
    }];
    [self.moneyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.headerIcon.mas_right).offset(9);
        make.bottom.equalTo(self.mas_bottom).offset(-20);
        make.height.mas_equalTo(12);
    }];
    [self.payLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.moneyLabel.mas_right);
        make.height.mas_equalTo(18);
        make.bottom.equalTo(self.moneyLabel.mas_bottom).offset(1);
    }];
}
- (UIImageView *)headerIcon {
    if (!_headerIcon) {
        _headerIcon = [[UIImageView alloc] init];
        _headerIcon.backgroundColor = UIColor.orangeColor;
        _headerIcon.layer.cornerRadius = 35.f;
        _headerIcon.layer.masksToBounds = YES;
        _headerIcon.contentMode = UIViewContentModeScaleAspectFill;
    }
    return _headerIcon;
}
- (GMLabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:17];
    }
    return _titleLabel;
}
- (GMLabel *)organizationLabel {
    if (!_organizationLabel) {
        _organizationLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:13];
    }
    return _organizationLabel;
}
- (GMLabel *)moneyLabel {
    if (!_moneyLabel) {
        _moneyLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x999999) fontSize:10];
        _moneyLabel.text = @"金额：";
    }
    return _moneyLabel;
}
- (GMLabel *)payLabel {
    if (!_payLabel) {
        _payLabel = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0xFF5963) fontSize:16];
    }
    return _payLabel;
}
@end
