//
//  GMToFacePaySectionHeaderView.m
//  Gengmei
//
//  Created by zhouLiang on 2020/4/7.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFacePaySectionHeaderView.h"
@import GMKit;

@interface GMToFacePaySectionHeaderView ()
@property (nonatomic, strong) UIView *labelView;
@property (nonatomic, strong) UIView *lineView;
@property (nonatomic, strong) UIView *grayView;
@end

@implementation GMToFacePaySectionHeaderView

- (instancetype)init {
    if (self = [super init]) {
        [self setUI];
        self.backgroundColor = UIColor.whiteColor;
    }
    return self;
}
- (void)setUI {
    
    [self addSubview:self.grayView];
    [self addSubview:self.labelView];
    [self addSubview:self.lineView];
    
    [self.grayView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.right.mas_equalTo(0);
        make.height.mas_equalTo(5);
    }];
    [self.labelView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.top.equalTo(self.grayView.mas_bottom);
        make.height.mas_equalTo(45);
    }];
    [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(0.5);
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.top.equalTo(self.labelView.mas_bottom);
    }];
}

- (UIView *)grayView {
    if (!_grayView) {
        _grayView = [[UIView alloc] init];
        _grayView.backgroundColor = RGBCOLOR_HEX(0xF7F6FA);
    }
    return _grayView;
}
- (UIView *)lineView {
    if (!_lineView) {
        _lineView = [[UIView alloc] init];
        _lineView.backgroundColor = RGBCOLOR_HEX(0xE5E5E5);
    }
    return _lineView;
}
- (UIView *)labelView {
    if (!_labelView) {
        _labelView = [[UIView alloc] init];
        GMLabel *label = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:15];
        label.text = @"请选择支付方式";
        [_labelView addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_equalTo(0);
            make.left.mas_equalTo(15);
        }];
    }
    return _labelView;
}

@end
