//
//  GMToFacePayTypeCell.m
//  Gengmei
//
//  Created by zhouLiang on 2020/4/8.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMToFacePayTypeCell.h"
@import GMBase;
@import SDWebImage;
@interface GMToFacePayTypeCell ()
@property (strong, nonatomic) UIImageView *payWayImage;
@property (strong, nonatomic) GMLabel *payName;
@property (strong, nonatomic) GMLabel *payDesc;
/** 后面勾选的状态 */
@property (strong, nonatomic) UIImageView *statusIcon;
/** 推荐icon */
@property (strong, nonatomic) UIImageView *recommendIcon;
@end

@implementation GMToFacePayTypeCell

- (void)setup {
    [super setup];
    [self setUI];
    self.bottomLine.hidden = YES;
}
- (void)setTypeModel:(GMToFacePayTypeModel *)typeModel {
    _typeModel = typeModel;
    [self.payWayImage sd_setImageWithURL:[NSURL URLWithString:typeModel.icon]];
    self.payDesc.text = typeModel.desc;
    self.payName.text = typeModel.title;
    self.payDesc.textColor = typeModel.recommend?RGBCOLOR_HEX(0xFF5963):RGBCOLOR_HEX(0x999999);
    self.recommendIcon.hidden = !typeModel.recommend;
}
- (void)setUI {
    [self.contentView addSubview:self.payWayImage];
    [self.contentView addSubview:self.payName];
    [self.contentView addSubview:self.payDesc];
    [self.contentView addSubview:self.statusIcon];
    [self.contentView addSubview:self.recommendIcon];
}
- (void)cellConstraints {
    [self.payWayImage mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(40, 40));
        make.bottom.mas_equalTo(0);
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(20);
    }];
    [self.payName mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.payWayImage.mas_right).offset(12);
        make.top.equalTo(self.payWayImage.mas_top).offset(4);
        make.height.mas_equalTo(15);
        make.right.mas_equalTo(-100);
    }];
    [self.payDesc mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.payName.mas_left);
        make.bottom.equalTo(self.payWayImage.mas_bottom).offset(-4);
        make.height.mas_equalTo(13);
        make.right.mas_equalTo(-100);
    }];
    [self.statusIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(18, 18));
        make.centerY.equalTo(self.payWayImage.mas_centerY);
        make.right.equalTo(self.contentView.mas_right).offset(-15);
    }];
    [self.recommendIcon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(32, 16));
        make.top.equalTo(self.statusIcon.mas_top);
        make.right.equalTo(self.statusIcon.mas_left).offset(-18);
    }];
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    self.statusIcon.highlighted = selected;
}
- (UIImageView *)payWayImage {
    if (!_payWayImage) {
        _payWayImage = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"gm_pay_zhifubao"]];
    }
    return _payWayImage;
}
- (GMLabel *)payName {
    if (!_payName) {
        _payName = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0x282828) fontSize:14];
    }
    return _payName;
}
- (GMLabel *)payDesc {
    if (!_payDesc) {
        _payDesc = [GMLabel labelWithTextColor:RGBCOLOR_HEX(0xFF5963) fontSize:12];
    }
    return _payDesc;
}
- (UIImageView *)recommendIcon {
    if (!_recommendIcon) {
        _recommendIcon = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"pay_recommend"]];
    }
    return _recommendIcon;
}
- (UIImageView *)statusIcon {
    if (!_statusIcon) {
        _statusIcon = [[UIImageView alloc] init];
        _statusIcon.highlightedImage = [UIImage imageNamed:@"cart_duihao"];
        _statusIcon.image = [UIImage imageNamed:@"cart_huiduihao"];
    }
    return _statusIcon;
}
@end
