//
//  GMTofaceOrderDetailViewController.m
//  Gengmei
//
//  Created by Jessica on 2020/4/13.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTofaceOrderDetailViewController.h"
#import "GMComplaintObject.h"
#import "GMComplaintResultView.h"
//#import "Gengmei-Swift.h"
#import "GMEndConsultView.h"
#import "RequestHeader.h"
#import "GMToFaceNetworking.h"
#import <GMBaseWeb/GMBaseWeb-Swift.h>
#import <WebKit/WebKit.h>
@import GMHud;
@interface GMTofaceOrderDetailViewController () <WKBaseWebViewDelegate>
@property (nonatomic, strong) GMComplaintObject *complaintObject;

@end

@implementation GMTofaceOrderDetailViewController

-(void)initController {
    [super initController];
    self.path = API_USER_RECORD_DETAIL_V4;
    self.pageName = @"video_face_consultation_order_detail";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.businessId = SafeString(_orderNo);
}

- (NSString *)moreQueryParameters {
    NSMutableString *param = [NSMutableString string];
    [param appendString:[NSString stringWithFormat:@"&record_id=%@", SafeString(_recordId)]];
    [param appendString:[NSString stringWithFormat:@"&order_no=%@", SafeString(_orderNo)]];
    [param appendString:[NSString stringWithFormat:@"&show_report=%@", SafeString(_showReport)]];
    [param appendString:[NSString stringWithFormat:@"&confirm=%ld", _confirm]];
    [param appendString:[NSString stringWithFormat:@"&complaint=%ld", _complaint]];
    return param;
}

#pragma mark - 查看投诉
- (void)viewComplaint:(NSString *)jsonString {
    NSString *diagnosisId = SafeString(jsonString);
    [GMHudModule showLoading:nil];
    [[GMToFaceNetworking shareInstance] excuteToFaceComplaintGetDiagnosis_id:diagnosisId SuccessBlock:^(id response) {
        [GMHudModule hideLoading];
        GMComplaintInterfaceObject *model = [[GMComplaintInterfaceObject alloc] initWithDictionary:response error:nil];
        self.complaintObject.report_detail = model.complaint.content;
        self.complaintObject.report_time = model.complaint.time;
        self.complaintObject.deal_detail = model.reply.content;
        self.complaintObject.deal_time = model.reply.time;
        self.complaintObject.custom_url = model.custom_url;
        self.complaintObject.status = model.status;
        GMComplaintResultView *view = [[GMComplaintResultView alloc] initWithType:self.complaintObject.status dictModel:self.complaintObject];
        [[GMBaseTool mainWindow]  addSubview:view];
    } failureBlock:^(NSInteger errorCode, NSString *message) {
        [GMHudModule hideLoading];
        [[GMBaseTool getCurrentViewController] toast:message];
    }];
}
#pragma mark - 去投诉
- (void)showComplaint:(NSString *)jsonString {
    NSString *recordId = SafeString(jsonString);
    GMEndConsultView *view = [[GMEndConsultView alloc] initWithType:GMEndConsultViewTypeUserComplaint starNum:0];
    view.recordId = recordId;
    view.complaintType = GMComplaintTypeDoctor;
    view.complaintFinish = ^(NSInteger complaintStatus) {
        NSString *jsStr = [NSString stringWithFormat:@"window.gm&&window.gm.pack&&window.gm.pack.run('notificReportState')"];
        [self.webCompent.webView evaluateJavaScript:jsStr completionHandler:nil];
    };
    [[GMBaseTool getCurrentViewController].view addSubview:view];
}

- (GMComplaintObject *)complaintObject {
    if (!_complaintObject) {
        _complaintObject = [[GMComplaintObject alloc] init];
    }
    return _complaintObject;
}
@end
