//
//  GMToFacePayViewModel.h
//  Gengmei
//
//  Created by zhouLiang on 2020/4/9.
//  Copyright © 2020 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
@import GMNetService;
NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger, GMToFacePayType) {
    /** 支付宝 */
    GMToFacePayTypeAlipay,
    /** 微信 */
    GMToFacePayTypeWechat
};
@interface GMToFacePayViewModel : NSObject
/** 支付方式 */
@property (nonatomic, assign) GMToFacePayType payType;
/** 订单号 */
@property (nonatomic, copy) NSString *orderNo;
/** 支付价格 */
@property (nonatomic, assign) NSInteger paymentAmount;

/** 支付接口 */
- (void)excuteToFacePayCompleteBlock:(HttpSuccessBlock)successBlock failedBlock:(HttpFailedBlock)failedBlock;
/**
 * 是否要无限递归
 * 1、成功：一直轮循后端的支付状态接口
 * 2、失败与未收到回调：只请求支付状态接口一次
 */
@property (nonatomic, assign) BOOL needRepeat;

/** 查询后端的支付状态 */
- (void)excuteToFacePayQueryBacksSuccessBlock:(HttpSuccessBlock)successBlock failBlock:(HttpFailedBlock)failBlock;

@end

NS_ASSUME_NONNULL_END
